###################################################
### chunk number 1: set width
###################################################
#line 29 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
options(width=60)
options(continue=" ")
try(X11.options(type="xlib"), silent=TRUE)


###################################################
### chunk number 2: packages
###################################################
#line 69 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
library(biclust)
library(eisa)
library(ALL)
data(ALL)


###################################################
### chunk number 3: filter
###################################################
#line 81 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
library(GO.db)
library(hgu95av2.db)
gotable <- toTable(GOTERM)
myterms <- unique(gotable$go_id[gotable$Term %in% c("immune system process")])
myprobes <- unique(unlist(mget(myterms, hgu95av2GO2ALLPROBES)))
ALL.filtered <- ALL[myprobes,]


###################################################
### chunk number 4: filtered
###################################################
#line 91 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
nrow(ALL.filtered)


###################################################
### chunk number 5: seed
###################################################
#line 96 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
set.seed(0xf00)


###################################################
### chunk number 6: bcplaid
###################################################
#line 102 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
Bc <- biclust(exprs(ALL.filtered), BCPlaid(),
              fit.model = ~m + a + b, verbose = FALSE)


###################################################
### chunk number 7: bcplaid result
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
class(Bc)
Bc


###################################################
### chunk number 8: convert bc to isa
###################################################
#line 121 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
Bc@Parameters$annotation <- annotation(ALL.filtered)
modules <- as(Bc, "ISAModules")
modules


###################################################
### chunk number 9: biclust enrichment
###################################################
#line 134 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
library(KEGG.db)
KEGG <- ISAKEGG(modules)
sigCategories(KEGG)[[2]]
unlist(mget(sigCategories(KEGG)[[2]], KEGGPATHID2NAME))


###################################################
### chunk number 10: heatmap eval=FALSE
###################################################
## #line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
## col <- ifelse(grepl("^B", ALL.filtered$BT), "white", "black")
## modcol <- col[ getSamples(modules, 2)[[1]] ]
## ISA2heatmap(modules, 2, ALL.filtered, 
##             ColSideColors=modcol)


###################################################
### chunk number 11: heatmap-real
###################################################
#line 155 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
#line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw#from line#155#"
col <- ifelse(grepl("^B", ALL.filtered$BT), "white", "black")
modcol <- col[ getSamples(modules, 2)[[1]] ]
ISA2heatmap(modules, 2, ALL.filtered, 
            ColSideColors=modcol)
#line 156 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"


###################################################
### chunk number 12: profilePlot eval=FALSE
###################################################
## #line 173 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
## profilePlot(modules, 2, ALL, plot="both")


###################################################
### chunk number 13: profilePlot-real
###################################################
#line 178 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
#line 173 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw#from line#178#"
profilePlot(modules, 2, ALL, plot="both")
#line 179 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"


###################################################
### chunk number 14: psoptions
###################################################
#line 192 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
ps.options(fonts=c("serif", "mono"))


###################################################
### chunk number 15: GOtreeplot eval=FALSE
###################################################
## #line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
## library(GO.db)
## GO <- ISAGO(modules)
## gog <- gograph(summary(GO$CC)[[2]])
## summary(gog)
## gographPlot(gog)


###################################################
### chunk number 16: GOtreeplot-real
###################################################
#line 204 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
#line 195 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw#from line#204#"
library(GO.db)
GO <- ISAGO(modules)
gog <- gograph(summary(GO$CC)[[2]])
summary(gog)
gographPlot(gog)
#line 205 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"


###################################################
### chunk number 17: html
###################################################
#line 217 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
CHR <- ISACHR(modules)
htmldir <- tempdir()
ISAHTML(eset=ALL.filtered, modules=modules, target.dir=htmldir, 
        GO=GO, KEGG=KEGG, CHR=CHR, condPlot=FALSE)


###################################################
### chunk number 18: html-show eval=FALSE
###################################################
## #line 223 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
## if (interactive()) {
##   browseURL(URLencode(paste("file://", htmldir, "/index.html", sep="")))
## }


###################################################
### chunk number 19: mnplot eval=FALSE
###################################################
## #line 235 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
## group <- ifelse(grepl("^B", ALL.filtered$BT), "B-cell", "T-cell")
## ISAmnplot(modules, 2, ALL.filtered, norm="raw", group=group)


###################################################
### chunk number 20: mnplot-real
###################################################
#line 241 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
#line 235 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw#from line#241#"
group <- ifelse(grepl("^B", ALL.filtered$BT), "B-cell", "T-cell")
ISAmnplot(modules, 2, ALL.filtered, norm="raw", group=group)
#line 242 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"


###################################################
### chunk number 21: load isa data
###################################################
#line 259 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
data(ALLModules)
ALLModules


###################################################
### chunk number 22: isa to biclust
###################################################
#line 266 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
BcMods <- as(ALLModules, "Biclust")
BcMods


###################################################
### chunk number 23: coherence
###################################################
#line 276 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
data <- exprs(ALL[featureNames(ALLModules),])
constantVariance(data, BcMods, 1)
additiveVariance(data, BcMods, 1)
multiplicativeVariance(data, BcMods, 1)
signVariance(data, BcMods, 1)


###################################################
### chunk number 24: coherence vs robustness
###################################################
#line 286 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
cV <- sapply(1:BcMods@Number, function(x) constantVariance(data, BcMods, x))
aV <- sapply(1:BcMods@Number, function(x) additiveVariance(data, BcMods, x))
mV <- sapply(1:BcMods@Number, function(x) multiplicativeVariance(data, BcMods, x))
sV <- sapply(1:BcMods@Number, function(x) signVariance(data, BcMods, x))
rob <- ISARobustness(ALL, ALLModules)


###################################################
### chunk number 25: pairs eval=FALSE
###################################################
## #line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
## panel.low <- function(x, y) {
##   usr <- par("usr")
##   m <- c((usr[2]+usr[1])/2, (usr[4]+usr[3])/2)
##   text(m[1], m[2], adj=c(1/2,1/2), cex=1.5,
##        paste(sep="\n", "Correlation:", round(cor(x,y),2)))
## }
## pairs( cbind(cV, aV, mV, sV, rob), lower.panel=panel.low )


###################################################
### chunk number 26: pairs-real
###################################################
#line 307 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
#line 296 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw#from line#307#"
panel.low <- function(x, y) {
  usr <- par("usr")
  m <- c((usr[2]+usr[1])/2, (usr[4]+usr[3])/2)
  text(m[1], m[2], adj=c(1/2,1/2), cex=1.5,
       paste(sep="\n", "Correlation:", round(cor(x,y),2)))
}
pairs( cbind(cV, aV, mV, sV, rob), lower.panel=panel.low )
#line 308 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"


###################################################
### chunk number 27: sessioninfo
###################################################
#line 327 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpIMSPNt/R.INSTALL6efd285d/eisa/inst/doc/EISA_biclust.Rnw"
toLatex(sessionInfo())


