###################################################
### chunk number 1: 
###################################################
#line 38 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
require("limma")
arrayFiles  <- list.files(system.file("sampleData", package = "cghMCR"), 
     full.names = TRUE, pattern = "TCGA")
arrayFiles


###################################################
### chunk number 2: 
###################################################
#line 47 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
rawData <- read.maimages(arrayFiles, source = "agilent", columns = 
    list(R = "rMedianSignal", G = "gMedianSignal", Rb = "rBGMedianSignal", 
    Gb = "gBGMedianSignal"), annotation = c("Row", "Col", "ControlType", 
    "ProbeName", "GeneName", "SystematicName", "PositionX", "PositionY", 
    "gIsFeatNonUnifOL", "rIsFeatNonUnifOL", "gIsBGNonUnifOL", "rIsBGNonUnifOL",
    "gIsFeatPopnOL", "rIsFeatPopnOL", "gIsBGPopnOL", "rIsBGPopnOL", 
    "rIsSaturated", "gIsSaturated"), names = basename(arrayFiles))


###################################################
### chunk number 3: 
###################################################
#line 59 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
rawData$design <- c(-1, -1, -1)


###################################################
### chunk number 4: 
###################################################
#line 65 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
ma <- normalizeWithinArrays(backgroundCorrect(rawData, method = "minimum"), method = "loess")


###################################################
### chunk number 5: 
###################################################
#line 71 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
chrom <- gsub("chr([0-9XY]+):.*", "\\1", ma$genes[, "SystematicName"])
dropMe <- c(which(!chrom %in% c(1:22, "X", "Y")), which(ma$genes[, "ControlType"] != 0))


###################################################
### chunk number 6: 
###################################################
#line 78 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
require(DNAcopy, quietly = TRUE)
set.seed(25)
cna <- CNA(ma$M[-dropMe, ], 
    gsub("chr([0-9XY]+):.*", "\\1", ma$genes[-dropMe, "SystematicName"]),
    as.numeric(gsub(".*:([0-9]+)-.*", "\\1", 
      ma$genes[-dropMe, "SystematicName"])),
    data.type = "logratio", sampleid = colnames(ma$M)) 
segData <- segment(smooth.CNA(cna)) 


###################################################
### chunk number 7: 
###################################################
#line 91 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
mySeglist <- segData[["output"]]
head(mySeglist)


###################################################
### chunk number 8: 
###################################################
#line 100 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
require(CNTools, quietly = TRUE)
data("sampleData", package = "CNTools")
head(sampleData)


###################################################
### chunk number 9: 
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
data(geneInfo)
data(sampleData, package = "CNTools")
set.seed(1234)
convertedData <- getRS(CNSeg(sampleData[which(is.element(sampleData[, "ID"], sample(unique(sampleData[, "ID"]), 20))), ]), by = "gene", imput = FALSE, 
XY = FALSE, geneMap = geneInfo, what = "median")


###################################################
### chunk number 10: 
###################################################
#line 120 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
require(cghMCR, quietly = TRUE)
SGOLScores <- SGOL(convertedData, threshold = c(-0.2, 0.2), method = sum)
plot(SGOLScores)


###################################################
### chunk number 11: 
###################################################
#line 136 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
GOIGains <- SGOLScores[which(as.numeric(unlist(gol(SGOLScores[, "gains"]))) > 
     20), "gains"]
GOILosses <- SGOLScores[which(as.numeric(unlist(gol(SGOLScores[, "losses"]))) < 
     -20), "losses"]
head(gol(GOIGains))


###################################################
### chunk number 12: 
###################################################
#line 161 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
cghmcr <- cghMCR(segData, gapAllowed = 500, alteredLow = 0.9,
 alteredHigh = 0.9, recurrence = 100)
mcrs <- MCR(cghmcr)


###################################################
### chunk number 13: 
###################################################
#line 169 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
head(cbind(mcrs[, c("chromosome", "status", "mcr.start", "mcr.end", 
                     "samples")])) 


###################################################
### chunk number 14: 
###################################################
#line 176 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
mcrs <- mergeMCRProbes(mcrs[mcrs[, "chromosome"] == "7", ], as.data.frame(segData[["data"]]))
head(cbind(mcrs[, c("chromosome", "status", "mcr.start", "mcr.end", 
                     "probes")]))


###################################################
### chunk number 15: 
###################################################
#line 187 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpfVCqP4/R.INSTALL2cc04891/cghMCR/inst/doc/findMCR.Rnw"
sessionInfo()


