###################################################
### chunk number 1: loadlib
###################################################
#line 56 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
library(attract)
data(exprs.dat) 
data(samp.info)


###################################################
### chunk number 2: makeESet
###################################################
#line 66 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
loring.eset <- new("ExpressionSet")
loring.eset@assayData <- new.env()
assign("exprs", exprs.dat, loring.eset@assayData)
p.eset <- new("AnnotatedDataFrame", data=samp.info)
loring.eset@phenoData <- p.eset


###################################################
### chunk number 3: findAttractors
###################################################
#line 85 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
attractor.states <- findAttractors(loring.eset, "celltype", nperm=10, annotation="illuminaHumanv1.db")


###################################################
### chunk number 4: showSlots
###################################################
#line 97 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
class(attractor.states) 
slotNames(attractor.states) 


###################################################
### chunk number 5: removeFlats
###################################################
#line 117 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
remove.these.genes <- removeFlatGenes(loring.eset, "celltype", contrasts=NULL, limma.cutoff=0.05)


###################################################
### chunk number 6: findSynE
###################################################
#line 141 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
mapk.syn <- findSynexprs("04010", attractor.states, remove.these.genes)


###################################################
### chunk number 7: showSynSlots
###################################################
#line 149 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
class(mapk.syn)
slotNames(mapk.syn)


###################################################
### chunk number 8: howMany
###################################################
#line 164 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
length(mapk.syn@groups) 
sapply(mapk.syn@groups, length) 


###################################################
### chunk number 9: findMultiSynE
###################################################
#line 177 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
top5.syn <- findSynexprs(attractor.states@rankedPathways[1:5,1], attractor.states, removeGenes=remove.these.genes)


###################################################
### chunk number 10: demoEnv
###################################################
#line 189 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
ls(top5.syn) 


###################################################
### chunk number 11: demoClass
###################################################
#line 197 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
class(get(ls(top5.syn)[1], top5.syn))


###################################################
### chunk number 12: plotSyn
###################################################
#line 207 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
par(mfrow=c(2,2)) 
pretty.col <- rainbow(3) 
for( i in 1:3 ){
	plotsynexprs(mapk.syn, tickMarks=c(6, 28, 47, 60), tickLabels=c("ESC", "PRO", "NSC", "TER"), vertLines=c(12.5, 43.5, 51.5), index=i, 
			main=paste("Synexpression Group ", i, sep=""), col=pretty.col[i])
 }


###################################################
### chunk number 13: findCorrP
###################################################
#line 239 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
mapk.cor <- findCorrPartners(mapk.syn, loring.eset, remove.these.genes)


###################################################
### chunk number 14: lookatCorr
###################################################
#line 248 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
sapply(mapk.cor@groups, length)


###################################################
### chunk number 15: funcE
###################################################
#line 257 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
mapk.func <- calcFuncSynexprs(mapk.syn, attractor.states, "CC", annotation="illuminaHumanv1.db") 


###################################################
### chunk number 16: SessionInfo
###################################################
#line 283 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpBDS4ge/R.INSTALL17317d5c/attract/inst/doc/attract.Rnw"
sessionInfo()


