###################################################
### chunk number 1: 
###################################################
#line 59 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
library(aCGH)

datadir <- system.file(package = "aCGH")
datadir <- paste(datadir, "/examples", sep="")

clones.info <-
      read.table(file = file.path(datadir, "clones.info.ex.txt"),
                 header = T, sep = "\t", quote="", comment.char="")
log2.ratios <-
      read.table(file = file.path(datadir, "log2.ratios.ex.txt"),
                 header = T, sep = "\t", quote="", comment.char="")
pheno.type <-
      read.table(file = file.path(datadir, "pheno.type.ex.txt"),
                 header = T, sep = "\t", quote="", comment.char="")
ex.acgh <- create.aCGH(log2.ratios, clones.info, pheno.type)


###################################################
### chunk number 2: 
###################################################
#line 83 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
ex.acgh <-
    aCGH.process(ex.acgh, chrom.remove.threshold = 23, prop.missing = .25, sample.quality.threshold = .4, unmapScreen=TRUE, dupRemove = FALSE)


###################################################
### chunk number 3: 
###################################################
#line 90 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
log2.ratios.imputed(ex.acgh) <- impute.lowess(ex.acgh, maxChrom=24)


###################################################
### chunk number 4: 
###################################################
#line 97 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
data(colorectal)
colorectal
summary(colorectal)


###################################################
### chunk number 5: 
###################################################
#line 105 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plot(colorectal)


###################################################
### chunk number 6: 
###################################################
#line 114 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
sample.names(colorectal)
phenotype(colorectal)[1:4,]


###################################################
### chunk number 7: 
###################################################
#line 125 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
datadir <- system.file("examples", package = "aCGH")
latest.mapping.file <-
	file.path(datadir, "human.clones.info.Jul03.txt")
ex.acgh <-
	aCGH.read.Sprocs(dir(path = datadir,pattern = "sproc",
			full.names = TRUE), latest.mapping.file,
			chrom.remove.threshold = 23)
ex.acgh


###################################################
### chunk number 8: 
###################################################
#line 141 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plot(ex.acgh)


###################################################
### chunk number 9: 
###################################################
#line 152 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
cr <- colorectal[ ,1:3]


###################################################
### chunk number 10: 
###################################################
#line 166 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotGenome(ex.acgh, samples=2, Y = FALSE)


###################################################
### chunk number 11: 
###################################################
#line 185 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
## Determining hmm states of the clones. In the interest of time, 
##we have commented this step out and used pre-computed results. 

##hmm(ex.acgh) <- find.hmm.states(ex.acgh)
hmm(ex.acgh) <- ex.acgh.hmm

## Merging hmm states

hmm.merged(ex.acgh) <-
   mergeHmmStates(ex.acgh, model.use = 1, minDiff = .25)

## Calculating the standard deviations for each array. Standard error is 
##calculated for each region and then averaged across regions. The final 
##SDs for each samples are contained in sd.samples(exa.acgh)$madGenome.

sd.samples(ex.acgh) <- computeSD.Samples(ex.acgh)

## Finding the genomic events associated with each sample using 
##results of the partitioning into the states.

genomic.events(ex.acgh) <- find.genomic.events(ex.acgh)

## Plotting and printing the hmm states either to the screen or into the 
##postscript file. Each chromosome for each sample is plotted on a separate
##page

##postscript("hmm.states.temp.ps");plotHmmStates(ex.acgh, sample.ind=1);dev.off()


###################################################
### chunk number 12: 
###################################################
#line 218 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotHmmStates(colorectal, sample.ind = 1, chr = 1)


###################################################
### chunk number 13: 
###################################################
#line 248 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotFreqStat(colorectal, all = T)


###################################################
### chunk number 14: 
###################################################
#line 262 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
summarize.clones(colorectal)[1:10 ,]


###################################################
### chunk number 15: 
###################################################
#line 269 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
factor <- 3
tbl <- threshold.func(log2.ratios(colorectal),
            posThres=factor*(sd.samples(colorectal)$madGenome))
rownames(tbl) <- clone.names(colorectal)
colnames(tbl) <- sample.names(colorectal)
tbl[1:5,1:5]


###################################################
### chunk number 16: 
###################################################
#line 280 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
col.fga <- fga.func(colorectal, factor=3,chrominfo=human.chrom.info.Jul03)
cbind(gainP=col.fga$gainP,lossP=col.fga$lossP)[1:5,]


###################################################
### chunk number 17: 
###################################################
#line 298 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
colnames(phenotype(colorectal))
sex <- phenotype(colorectal)$sex
sex.na <- !is.na(sex)
index.clones.use <- which(clones.info(colorectal)$Chrom < 23)
colorectal.na <- colorectal[ index.clones.use,sex.na , keep=TRUE]
dat <- log2.ratios.imputed(colorectal.na)
resT.sex <- mt.maxT(dat, sex[sex.na], test = "t.equalvar", B = 1000)


###################################################
### chunk number 18: 
###################################################
#line 311 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotFreqStat(colorectal.na, resT.sex, sex[sex.na], factor=3, titles =
             c("Female", "Male"), X = FALSE, Y = FALSE)


###################################################
### chunk number 19: 
###################################################
#line 323 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotSummaryProfile(colorectal, response = sex,
                   titles = c("Female", "Male"),
                   X = FALSE, Y = FALSE, maxChrom = 22)


###################################################
### chunk number 20: 
###################################################
#line 337 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
factor <- 3
minChanged <- 0.1
gainloss <- gainLoss(log2.ratios(colorectal)[,sex.na], cols=1:length(which(sex.na)), thres=(factor*(sd.samples(colorectal)$madGenome))[sex.na])
ind.clones.use <- which(gainloss$gainP >= minChanged | gainloss$lossP>= minChanged & clones.info(colorectal)$Chrom < 23)
colorectal.na <- colorectal[ind.clones.use,sex.na, keep=TRUE]
dat <- log2.ratios.imputed(colorectal.na)
resT.sex <- mt.maxT(dat, sex[sex.na],test = "t.equalvar", B = 1000)



###################################################
### chunk number 21: 
###################################################
#line 351 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotFreqStat(colorectal.na, resT.sex, sex[sex.na],factor=factor,titles = c("Male", "Female"))


###################################################
### chunk number 22: 
###################################################
#line 362 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
time <- rexp(ncol(colorectal), rate = 1 / 12)
events <- rbinom(ncol(colorectal), size = 1, prob = .5)
surv.obj <- Surv(time, 	events)
surv.obj
stat.coxph <-
  aCGH.test(colorectal, surv.obj, test = "coxph",
	p.adjust.method = "fdr")
stat.coxph[1:10 ,]


###################################################
### chunk number 23: 
###################################################
#line 375 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotFreqStat(colorectal, stat.coxph, events, titles =
             c("Survived/Censored", "Dead"), X = FALSE, Y = FALSE)


###################################################
### chunk number 24: 
###################################################
#line 387 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
age <- phenotype(colorectal)$age
age.na <- which(!is.na(age))
age <- age[age.na]
colorectal.na <- colorectal[, age.na]
stat.age <-
  aCGH.test(colorectal.na, age, test = "linear.regression",
            p.adjust.method = "fdr")
stat.age[1:10 ,]


###################################################
### chunk number 25: 
###################################################
#line 400 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
plotFreqStat(colorectal.na, stat.age, ifelse(age < 70, 0, 1), titles =
             c("Young", "Old"), X = FALSE, Y = FALSE)


###################################################
### chunk number 26: 
###################################################
#line 410 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
sex <- phenotype(colorectal)$sex
sex.na <- !is.na(sex)
index.clones.use <- which(clones.info(colorectal.na)$Chrom < 23)
colorectal.na <- colorectal[ index.clones.use,sex.na , keep=TRUE]
dat <- log2.ratios.imputed(colorectal.na)
resT.sex <- mt.maxT(dat, sex[sex.na], test = "t.equalvar", B = 1000)

sex.tbl <- summarize.clones(colorectal.na, resT.sex, sex[sex.na], titles = c("Male", "Female"))
sex.tbl[1:5,]


###################################################
### chunk number 27: 
###################################################
#line 436 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpJl3Gj8/R.INSTALL4627cf7/aCGH/inst/doc/aCGH.Rnw"
par(mfrow=c(2,1))
clusterGenome(colorectal.na, response = sex[sex.na],
		titles = c("Female", "Male"),
		byclass = FALSE, showaber = TRUE, vecchrom = c(4,8,9),
		dendPlot = FALSE, imp = FALSE)
clusterGenome(colorectal.na, response = sex[sex.na],
		titles = c("Female", "Male"),
		byclass = TRUE, showaber = TRUE, vecchrom = c(4,8,9),
		dendPlot = FALSE, imp = FALSE)



