###################################################
### chunk number 1: 
###################################################
#line 37 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
library(PGSEA)
library(GEOquery)
library(GSEABase)
gse <- getGEO("GSE7023",GSEMatrix=TRUE)
#load("gse.rda")


###################################################
### chunk number 2: 
###################################################
#line 46 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
subtype <- gsub("\\.", "_",gsub("subtype: ", "", phenoData(gse[[1]])$"characteristics_ch1"))
pheno <- new("AnnotatedDataFrame", data = data.frame(subtype), varMetadata = data.frame(labelDescription="subtype"))
rownames(pheno@data) <- colnames(exprs(gse[[1]]))
eset <- new("ExpressionSet", exprs = exprs(gse[[1]]), phenoData = pheno)


###################################################
### chunk number 3: 
###################################################
#line 55 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
data(VAIgsc)
details(VAIgsc[[1]])


###################################################
### chunk number 4: 
###################################################
#line 64 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
pg <- PGSEA(eset, VAIgsc, ref=which(subtype=="NO"))


###################################################
### chunk number 5: 
###################################################
#line 70 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
pg[5:8, 5:8]


###################################################
### chunk number 6: 
###################################################
#line 79 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
range(pg, finite=TRUE)
smcPlot(pg, col=.rwb, scale=c(-15, 15))


###################################################
### chunk number 7: 
###################################################
#line 88 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
smcPlot(pg, factor(subtype), col=.rwb, scale=c(-15, 15), margins=c(1, 1, 6, 9), show.grid=TRUE, r.cex=.75)


###################################################
### chunk number 8: 
###################################################
#line 97 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
pgNF <- PGSEA(eset, VAIgsc, ref=which(subtype=="NO"), p.value=NA)

library(limma)

design <- model.matrix(~ -1+factor(subtype))
colnames(design) <- names(table(subtype))
fit <- lmFit(pgNF, design)
contrast.matrix <- makeContrasts(P2B-NO , levels=design)
fit <- contrasts.fit(fit, contrast.matrix)
fit <- eBayes(fit)

topTable(fit, n=10)[,c("logFC","t","adj.P.Val")]


###################################################
### chunk number 9: 
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
smcPlot(pg[as.numeric(rownames(topTable(fit, n=10))),], factor(subtype,levels=c("P1","P2B")), col=.rwb, scale=c(-15, 15), margins=c(1, 1, 6, 19), show.grid=TRUE, r.cex=.75)


###################################################
### chunk number 10: 
###################################################
#line 128 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
gos <- go2smc()
pg <- PGSEA(eset, gos, ref=which(subtype=="NO"))
pgNF <- PGSEA(eset, gos, ref=which(subtype=="NO"), p.value=NA)
#load("ABC.rda")
design <- model.matrix(~ -1+factor(subtype))
colnames(design) <- names(table(subtype))
fit <- lmFit(pgNF, design)
contrast.matrix <- makeContrasts(P2B-P1,levels=design)
fit <- contrasts.fit(fit, contrast.matrix)
fit <- eBayes(fit)


###################################################
### chunk number 11: 
###################################################
#line 144 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpOGU2WQ/R.INSTALL1c233795/PGSEA/inst/doc/PGSEA2.Rnw"
smcPlot(pg[as.numeric(rownames(topTable(fit,n=30,resort.by="logFC"))),], factor(subtype,levels=c("P1","P2B")), col=.rwb, scale=c(-15, 15), margins=c(1, 1, 6, 19), show.grid=TRUE, r.cex=.75)


