###################################################
### chunk number 1: lib
###################################################
#line 58 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
library(KEGGgraph)


###################################################
### chunk number 2: remoteRetrieval eval=FALSE
###################################################
## #line 77 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
## library(KEGG.db)
## tmp <- tempfile()
## pName <- "p53 signaling pathway"
## pId <- mget(pName, KEGGPATHNAME2ID)[[1]]
## retrieveKGML(pId, organism="cel", destfile=tmp, method="wget", quiet=TRUE)


###################################################
### chunk number 3: library
###################################################
#line 103 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkKGML <- system.file("extdata/hsa04010.xml",
                     package="KEGGgraph")


###################################################
### chunk number 4: parsemapk
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkG <- parseKGML2Graph(mapkKGML,expandGenes=TRUE)
mapkG


###################################################
### chunk number 5: parsemapk2
###################################################
#line 113 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkpathway <- parseKGML(mapkKGML)
mapkpathway
mapkG2 <- KEGGpathway2Graph(mapkpathway, expandGenes=TRUE)
mapkG2


###################################################
### chunk number 6: nodeandedge
###################################################
#line 130 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkNodes <- nodes(mapkG)
nodes(mapkG)[1:3]
mapkEdges <- edges(mapkG)
edges(mapkG)[1]


###################################################
### chunk number 7: keggnodedata
###################################################
#line 140 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkGnodedata <- getKEGGnodeData(mapkG)
mapkGnodedata[[2]]


###################################################
### chunk number 8: keggnodedataalt eval=FALSE
###################################################
## #line 145 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
## getKEGGnodeData(mapkG, 'hsa:5924')


###################################################
### chunk number 9: keggedgedata
###################################################
#line 151 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkGedgedata <- getKEGGedgeData(mapkG)
mapkGedgedata[[4]]


###################################################
### chunk number 10: keggedgedataalt eval=FALSE
###################################################
## #line 156 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
## getKEGGedgeData(mapkG,'hsa:627~hsa:4915')


###################################################
### chunk number 11: inout
###################################################
#line 167 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkGoutdegrees <- sapply(edges(mapkG), length)
mapkGindegrees <- sapply(inEdges(mapkG), length)
topouts <- sort(mapkGoutdegrees, decreasing=T)
topins <- sort(mapkGindegrees, decreasing=T)
topouts[1:3]
topins[1:3]


###################################################
### chunk number 12: subsetprepare
###################################################
#line 180 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
library(Rgraphviz)
set.seed(123)
randomNodes <- sample(nodes(mapkG), 25)
mapkGsub <- subGraph(randomNodes, mapkG)
mapkGsub


###################################################
### chunk number 13: makeattr
###################################################
#line 193 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
makeAttr <- function(graph, default, valNodeList) {
  tmp <- nodes(graph)
  x <- rep(default, length(tmp)); names(x) <- tmp
  
  if(!missing(valNodeList)) {
    stopifnot(is.list(valNodeList))
    allnodes <- unlist(valNodeList)
    stopifnot(all(allnodes %in% tmp))
    for(i in seq(valNodeList)) {
      x[valNodeList[[i]]] <- names(valNodeList)[i]
    }
  }
  return(x)
}


###################################################
### chunk number 14: subsetplot
###################################################
#line 212 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
outs <- sapply(edges(mapkGsub), length) > 0
ins <- sapply(inEdges(mapkGsub), length) > 0
ios <- outs | ins

## translate the KEGG IDs into Gene Symbol
if(require(org.Hs.eg.db)) {
  ioGeneID <- translateKEGGID2GeneID(names(ios))
  nodesNames <- sapply(mget(ioGeneID, org.Hs.egSYMBOL, ifnotfound=NA), "[[",1)
} else {
  nodesNames <- names(ios)
}
names(nodesNames) <- names(ios)

nAttrs <- list();
nAttrs$fillcolor <- makeAttr(mapkGsub, "lightgrey", list(orange=names(ios)[ios]))
nAttrs$label <- nodesNames
plot(mapkGsub, "neato", nodeAttrs=nAttrs,
     attrs=list(node=list(fillcolor="lightgreen",
                  width="0.75", shape="ellipse"), 
       edge=list(arrowsize="0.7")))


###################################################
### chunk number 15: mergedemo
###################################################
#line 239 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
wntKGML <- system.file("extdata/hsa04310.xml",package="KEGGgraph")
wntG <- parseKGML2Graph(wntKGML)
graphs <- list(mapk=mapkG, wnt=wntG)
merged <- mergeGraphs(graphs)
merged


###################################################
### chunk number 16: bcc
###################################################
#line 273 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
library(RBGL)
bcc <- brandes.betweenness.centrality(mapkG)
rbccs <- bcc$relative.betweenness.centrality.vertices[1L,]
toprbccs <- sort(rbccs,decreasing=TRUE)[1:4]
toprbccs


###################################################
### chunk number 17: bccplot
###################################################
#line 287 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
toprbccName <- names(toprbccs)
toprin <- sapply(toprbccName, function(x) inEdges(mapkG)[x])
toprout <- sapply(toprbccName, function(x) edges(mapkG)[x])
toprSubnodes <- unique(unname(c(unlist(toprin), unlist(toprout), toprbccName)))
toprSub <- subGraph(toprSubnodes, mapkG)

nAttrs <- list()
tops <- c("MAPK3K1","GRB2","MAP2K2","MAP2K1")
topLabels <- lapply(toprbccName, function(x) x); names(topLabels) <- tops
nAttrs$label <- makeAttr(toprSub, "", topLabels)
nAttrs$fillcolor <- makeAttr(toprSub, "lightblue", list(orange=toprbccName))
nAttrs$width <- makeAttr(toprSub,"",list("0.8"=toprbccName))

plot(toprSub, "twopi", nodeAttrs=nAttrs, attrs=list(graph=list(start=2)))


###################################################
### chunk number 18: help eval=FALSE
###################################################
## #line 311 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
## help(package=KEGGgraph)


###################################################
### chunk number 19: reactionexample
###################################################
#line 329 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapfile <-  system.file("extdata/map00260.xml",package="KEGGgraph")
map <- parseKGML(mapfile)
map
reactions <- getReactions(map)
reactions[[1]]


###################################################
### chunk number 20: cnexample
###################################################
#line 341 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
chemicalGraph <- KEGGpathway2reactionGraph(map)

outDegrees <- sapply(edges(chemicalGraph), length)
maxout <- names(sort(outDegrees,decreasing=TRUE))[1:3]

nAttrs <- list()
maxoutlabel <- as.list(maxout); names(maxoutlabel) <- maxout
nAttrs$label <- makeAttr(chemicalGraph, "", maxoutlabel)
nAttrs$fillcolor <- makeAttr(chemicalGraph, "lightblue", list(orange=maxout))
nAttrs$width <- makeAttr(chemicalGraph,"0.8", list("1.8"=maxout))
plot(chemicalGraph, nodeAttrs=nAttrs)


###################################################
### chunk number 21: mapk14expand eval=FALSE
###################################################
## #line 360 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
## mapkGembed <- parseKGMLexpandMaps(mapkKGML)


###################################################
### chunk number 22: subgraphbynode
###################################################
#line 365 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
mapkGall <- parseKGML2Graph(mapkKGML,genesOnly=FALSE)
mapkGall
mapkGsub <- subGraphByNodeType(mapkGall, "gene")
mapkGsub


###################################################
### chunk number 23: biomart
###################################################
#line 374 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
toprbccKEGGID <- names(toprbccs)
toprbccKEGGID
toprbccGeneID <- translateKEGGID2GeneID(toprbccKEGGID)
toprbccGeneID


###################################################
### chunk number 24: orgHuman
###################################################
#line 383 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
if(require(org.Hs.eg.db)) {
  tnodes <- nodes(toprSub)
  tgeneids <- translateKEGGID2GeneID(tnodes)
  tgenesymbols <- sapply(mget(tgeneids, org.Hs.egSYMBOL, ifnotfound=NA), "[[",1)
  toprSubSymbol <- toprSub
  nodes(toprSubSymbol) <- tgenesymbols
  plot(toprSubSymbol, "neato",attrs=list(node=list(font=5, fillcolor="lightblue")))
}


###################################################
### chunk number 25: biomart2 eval=FALSE
###################################################
## #line 395 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
## library(biomaRt)
## hsapiens <- useMart("ensembl","hsapiens_gene_ensembl" )
## filters <- listFilters(hsapiens)
## getBM(attributes=c("entrezgene","hgnc_symbol"), 
##       filters="entrezgene", 
##       values=toprbccGeneID, mart=hsapiens)


###################################################
### chunk number 26: sessionInfo
###################################################
#line 414 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpk5BeOg/R.INSTALL526583b/KEGGgraph/inst/doc/KEGGgraph.Rnw"
sessionInfo()


