###################################################
### chunk number 1: options
###################################################
#line 38 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
options(width=72)


###################################################
### chunk number 2: biocLite eval=FALSE
###################################################
## #line 55 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
## source("http://bioconductor.org/biocLite.R")
## biocLite("IRanges")


###################################################
### chunk number 3: initialize
###################################################
#line 59 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
library(IRanges)


###################################################
### chunk number 4: initialize
###################################################
#line 84 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
set.seed(0)
lambda <- c(rep(0.001, 4500), seq(0.001, 10, length = 500), 
            seq(10, 0.001, length = 500))
xVector <- rpois(1e7, lambda)
yVector <- rpois(1e7, lambda[c(251:length(lambda), 1:250)])


###################################################
### chunk number 5: basic-ops
###################################################
#line 98 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
length(xVector)
xVector[1]
zVector <- c(xVector, yVector)


###################################################
### chunk number 6: seq-extraction
###################################################
#line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xSnippet <- window(xVector, start = 4751, end = 4760)
xSnippet
head(xSnippet)
tail(xSnippet)
rev(xSnippet)
rep(xSnippet, 2)
window(xSnippet, delta = 2)
seqselect(xSnippet, start = c(6,1), end = c(10, 5))
subset(xSnippet, xSnippet >= 5L)


###################################################
### chunk number 7: seq-combine
###################################################
#line 165 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
c(xSnippet, rev(xSnippet))
append(xSnippet, xSnippet, after = 3)


###################################################
### chunk number 8: aggregate
###################################################
#line 189 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xSnippet
aggregate(xSnippet, start = 1:8, width = 3, FUN = median)


###################################################
### chunk number 9: shiftApply-cor
###################################################
#line 203 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
cor(xVector, yVector)
shifts <- seq(235, 265, by=3)
corrs  <- shiftApply(shifts, yVector, xVector, FUN = cor)


###################################################
### chunk number 10: figshiftcorrs
###################################################
#line 209 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
plot(shifts, corrs)


###################################################
### chunk number 11: Rle-construction
###################################################
#line 240 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xRle <- Rle(xVector)
yRle <- Rle(yVector)
xRle
yRle


###################################################
### chunk number 12: Rle-vector-compare
###################################################
#line 252 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
as.vector(object.size(xRle) / object.size(xVector))
identical(as.vector(xRle), xVector)


###################################################
### chunk number 13: Rle-accessors
###################################################
#line 260 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
head(runValue(xRle))
head(runLength(xRle))


###################################################
### chunk number 14: Rle-ops
###################################################
#line 270 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xRle > 0
xRle + yRle
xRle > 0 | yRle > 0


###################################################
### chunk number 15: Rle-summary
###################################################
#line 278 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
range(xRle)
sum(xRle > 0 | yRle > 0)


###################################################
### chunk number 16: Rle-math
###################################################
#line 285 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
log1p(xRle)


###################################################
### chunk number 17: Rle-cor
###################################################
#line 292 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
cor(xRle, yRle)
shiftApply(249:251, yRle, xRle, FUN = function(x, y) var(x, y) / (sd(x) * sd(y)))


###################################################
### chunk number 18: list-intro
###################################################
#line 320 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
getClassDef("RleList")


###################################################
### chunk number 19: list-construct
###################################################
#line 347 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
args(IntegerList)
cIntList1 <- IntegerList(x = xVector, y = yVector)
cIntList1
sIntList2 <- IntegerList(x = xVector, y = yVector, compress = FALSE)
sIntList2
## sparse integer list
xExploded <- lapply(xVector[1:5000], function(x) seq_len(x))
cIntList2 <- IntegerList(xExploded)
sIntList2 <- IntegerList(xExploded, compress = FALSE)
object.size(cIntList2)
object.size(sIntList2)


###################################################
### chunk number 20: list-length
###################################################
#line 366 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
length(cIntList2)
Rle(elementLengths(cIntList2))


###################################################
### chunk number 21: list-lapply
###################################################
#line 379 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
system.time(sapply(xExploded, mean))
system.time(sapply(sIntList2, mean))
system.time(sapply(cIntList2, mean))
identical(sapply(xExploded, mean), sapply(sIntList2, mean))
identical(sapply(xExploded, mean), sapply(cIntList2, mean))


###################################################
### chunk number 22: list-groupgenerics
###################################################
#line 394 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xRleList <- RleList(xRle, 2L * rev(xRle))
yRleList <- RleList(yRle, 2L * rev(yRle))
xRleList > 0
xRleList + yRleList
sum(xRleList > 0 | yRleList > 0)


###################################################
### chunk number 23: list-endoapply
###################################################
#line 405 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
safe.max <- function(x) { if(length(x)) max(x) else integer(0) }
endoapply(sIntList2, safe.max)
endoapply(cIntList2, safe.max)
endoapply(sIntList2, safe.max)[[1]]


###################################################
### chunk number 24: iranges-constructor
###################################################
#line 457 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ir1 <- IRanges(start = 1:10, width = 10:1)
ir2 <- IRanges(start = 1:10, end = 11)
ir3 <- IRanges(end = 11, width = 10:1)
identical(ir1, ir2) & identical(ir2, ir3)
ir <- IRanges(c(1, 8, 14, 15, 19, 34, 40),
  width = c(12, 6, 6, 15, 6, 2, 7))


###################################################
### chunk number 25: iranges-start
###################################################
#line 472 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
start(ir)


###################################################
### chunk number 26: iranges-end
###################################################
#line 475 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
end(ir)


###################################################
### chunk number 27: iranges-width
###################################################
#line 478 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
width(ir)


###################################################
### chunk number 28: iranges-subset-numeric
###################################################
#line 484 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ir[1:4]


###################################################
### chunk number 29: iranges-subset-logical
###################################################
#line 487 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ir[start(ir) <= 15]


###################################################
### chunk number 30: ranges-extraction
###################################################
#line 493 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ir[[1]]


###################################################
### chunk number 31: plotRanges
###################################################
#line 499 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
plotRanges <- function(x, xlim = x, main = deparse(substitute(x)),
                       col = "black", sep = 0.5, ...) 
{
  height <- 1
  if (is(xlim, "Ranges"))
    xlim <- c(min(start(xlim)), max(end(xlim)))
  bins <- disjointBins(IRanges(start(x), end(x) + 1))
  plot.new()
  plot.window(xlim, c(0, max(bins)*(height + sep)))
  ybottom <- bins * (sep + height) - height
  rect(start(x)-0.5, ybottom, end(x)+0.5, ybottom + height, col = col, ...)
  title(main)
  axis(1)
}


###################################################
### chunk number 32: ir-plotRanges
###################################################
#line 516 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
plotRanges(ir)


###################################################
### chunk number 33: ranges-reduce
###################################################
#line 554 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
reduce(ir)
plotRanges(reduce(ir))


###################################################
### chunk number 34: rangeslist-contructor
###################################################
#line 580 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
rl <- RangesList(ir, rev(ir))


###################################################
### chunk number 35: rangeslist-start
###################################################
#line 584 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
start(rl)


###################################################
### chunk number 36: seqselect-ranges
###################################################
#line 595 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
irextract <- IRanges(start = c(4501, 4901) , width = 100)
seqselect(xRle, irextract)


###################################################
### chunk number 37: bracket-ranges
###################################################
#line 604 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xRle[irextract]


###################################################
### chunk number 38: overlap-ranges
###################################################
#line 614 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ol <- findOverlaps(ir, reduce(ir))
as.matrix(ol)


###################################################
### chunk number 39: ranges-coverage
###################################################
#line 624 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
cov <- coverage(ir)
plotRanges(ir)
cov <- as.vector(cov)
mat <- cbind(seq_along(cov)-0.5, cov)
d <- diff(cov) != 0
mat <- rbind(cbind(mat[d,1]+1, mat[d,2]), mat)
mat <- mat[order(mat[,1]),]
lines(mat, col="red", lwd=4)
axis(2)


###################################################
### chunk number 40: ranges-shift
###################################################
#line 663 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
shift(ir, 10)


###################################################
### chunk number 41: ranges-plus
###################################################
#line 673 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ir + seq_len(length(ir))


###################################################
### chunk number 42: ranges-asterisk
###################################################
#line 681 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ir * -2 # half the width


###################################################
### chunk number 43: ranges-narrow
###################################################
#line 692 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
narrow(ir, start=1:5, width=2)


###################################################
### chunk number 44: ranges-threebands
###################################################
#line 699 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
threebands(ir, start=1:5, width=2)


###################################################
### chunk number 45: ranges-restrict
###################################################
#line 707 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
restrict(ir, start=2, end=3)


###################################################
### chunk number 46: ranges-disjoin
###################################################
#line 721 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
disjoin(ir)
plotRanges(disjoin(ir))


###################################################
### chunk number 47: ranges-disjointBins
###################################################
#line 737 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
disjointBins(ir)


###################################################
### chunk number 48: ranges-reflect
###################################################
#line 746 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
reflect(ir, IRanges(start(ir), width=width(ir)*2))


###################################################
### chunk number 49: ranges-flank
###################################################
#line 753 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
flank(ir, width = seq_len(length(ir)))


###################################################
### chunk number 50: ranges-gaps
###################################################
#line 776 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
gaps(ir, start=1, end=50)
plotRanges(gaps(ir, start=1, end=50), c(1,50))


###################################################
### chunk number 51: ranges-pgap
###################################################
#line 794 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 52: ranges-union
###################################################
#line 801 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 53: ranges-punion
###################################################
#line 803 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 54: ranges-intersect
###################################################
#line 805 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 55: ranges-pintersect
###################################################
#line 807 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 56: ranges-setdiff
###################################################
#line 809 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 57: ranges-psetdiff
###################################################
#line 811 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"


###################################################
### chunk number 58: Views-constructors
###################################################
#line 852 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
xViews <- Views(xRle, xRle >= 1)
xViews <- slice(xRle, 1)
xViewsList <- slice(xRleList, 1)


###################################################
### chunk number 59: views-looping
###################################################
#line 865 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
head(viewSums(xViews))
viewSums(xViewsList)
head(viewMaxs(xViews))
viewMaxs(xViewsList)


###################################################
### chunk number 60: RangedData-construct
###################################################
#line 885 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
values <- rnorm(length(ir))
rd <- RangedData(ir, name = letters[seq_len(length(ir))], values)
rd


###################################################
### chunk number 61: RangedData-construct-space
###################################################
#line 899 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
rd <- RangedData(ir, name = letters[seq_len(length(ir))], values, 
                 space = rep(c("chr1", "chr2"), c(3, length(ir) - 3)))
rd


###################################################
### chunk number 62: RangedData-ranges
###################################################
#line 909 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
ranges(rd)


###################################################
### chunk number 63: RangedData-values
###################################################
#line 912 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
values(rd)


###################################################
### chunk number 64: RangedData-subspace
###################################################
#line 919 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
rd["chr1"]


###################################################
### chunk number 65: RangedData-subspace-2
###################################################
#line 923 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
all(identical(rd["chr1"], rd[1]),
    identical(rd[1], rd[c(TRUE, FALSE)]))


###################################################
### chunk number 66: RangedData-names
###################################################
#line 929 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
names(rd)


###################################################
### chunk number 67: RangedData-length
###################################################
#line 932 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
length(rd)


###################################################
### chunk number 68: RangedData-lapply
###################################################
#line 938 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
lapply(rd, names)


###################################################
### chunk number 69: RangedData-extract
###################################################
#line 947 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
rd[[2]]


###################################################
### chunk number 70: RangedData-dollar
###################################################
#line 950 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
rd$values


###################################################
### chunk number 71: RangedData-subset-2d
###################################################
#line 961 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
rd[1:3, "name"]


###################################################
### chunk number 72: sessionInfo
###################################################
#line 999 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmpg08GnV/R.INSTALL70881704/IRanges/inst/doc/IRangesOverview.Rnw"
toLatex(sessionInfo())


