###################################################
### chunk number 1: 
###################################################
#line 46 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
library(HELP)


###################################################
### chunk number 2: 
###################################################
#line 49 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
data.path <- system.file("pipeline.data", package="HELP")


###################################################
### chunk number 3: 
###################################################
#line 82 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
msp1.files <- dir(data.path, pattern="532[._]pair", full.names=TRUE)
hpa2.files <- dir(data.path, pattern="635[._]pair", full.names=TRUE)
N <- length(msp1.files)
for (i in 1:N) {
	if (i == 1) {
		pairs <- readPairs(msp1.files[i],hpa2.files[i])
	}
	else {
		pairs <- readPairs(msp1.files[i],hpa2.files[i],pairs)
	}
}
class(pairs)
dim(pairs)
sampleNames(pairs)


###################################################
### chunk number 4: 
###################################################
#line 106 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
chips <- sub("[_.]*532[_.]*pair.*","",basename(msp1.files))
chips ## CHIP_IDs
samplekey <- file.path(data.path, "sample.key.txt")
chips <- readSampleKey(file=samplekey,chips=chips)
chips ## SAMPLEs (from supplied key)
sampleNames(pairs) <- chips


###################################################
### chunk number 5: 
###################################################
#line 122 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
ndf.file <- file.path(data.path, "HELP.ndf.txt")
ngd.file <- file.path(data.path, "HELP.ngd.txt")
pairs <- readDesign(ndf.file, ngd.file, pairs)
pData(featureData(pairs))[1:10,c("CHR","START","STOP")]
getFeatures(pairs,"SEQUENCE")[1]


###################################################
### chunk number 6: 
###################################################
#line 138 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
calcTm("ATCTAGGAAGATTTAGAGAGGCAATGTGTCATTTAGCATCTAATTTTACC")
calcTm(getFeatures(pairs,"SEQUENCE")[1:4])


###################################################
### chunk number 7: 
###################################################
#line 146 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
calcGC("ATCTAGGAAGATTTAGAGAGGCAATGTGTCATTTAGCATCTAATTTTACC")
calcGC(getFeatures(pairs,"SEQUENCE")[1:4])


###################################################
### chunk number 8: 
###################################################
#line 164 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
getSamples(pairs)[1:4,]
calcPrototype(pairs,center=FALSE)[1:4]


###################################################
### chunk number 9: fig1
###################################################
#line 181 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
plotChip(pairs, sample="Brain2")


###################################################
### chunk number 10: fig2
###################################################
#line 197 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
x <- rep(1:100,100)
y <- rep(1:100,each=100)
z <- x*(1001:11000/1000)
z <- z-mean(z)
z <- z*(sample(1:10000/10000)+1)
plotChip(x,y,z,main="Curved gradient",xlab="x",ylab="y")


###################################################
### chunk number 11: 
###################################################
#line 223 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
exprs(pairs) <- log2(exprs(pairs))
exprs2(pairs) <- log2(exprs2(pairs))


###################################################
### chunk number 12: fig3
###################################################
#line 227 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
plotFeature(pairs[,"Brain2"],cex=0.5)


###################################################
### chunk number 13: 
###################################################
#line 248 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
slopes <- (seq(from=1,to=10,length.out=20)-5.5)/4.5
x <- c()
for (i in 1:20) {
for (j in 1:10) {
x <- c(x,seq(from=0,to=slopes[i]*j,length.out=10))
}
}
y <- rep(1:20,each=100)


###################################################
### chunk number 14: fig4
###################################################
#line 258 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
plot(density(x),main="")
for (i in 1:20) {
d <- density(x[which(y==i)])
lines(d$x,0.3*d$y/max(d$y),col=rainbow(n=20,start=0,end=0.66)[21-i])
}
lines(density(x))


###################################################
### chunk number 15: fig5
###################################################
#line 281 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
x2 <- quantileNormalize(x,y,num.bins=20,num.steps=1,mode="discrete")
d2 <- density(x2)
plot(c(min(d2$x), max(d2$x)), c(0, 20), type="p", cex=0, ylab="Density (by bin)", xlab="", main="")
for (i in 1:20) {
d <- density(x2[which(y==i)])
lines(d$x, 0.5*i+0.25*(1+i/20)*20*d$y/max(d$y), col=rainbow(n=20,start=0,end=0.66)[21-i], lty="solid")
}


###################################################
### chunk number 16: 
###################################################
#line 305 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
rand <- which(getFeatures(pairs, "TYPE")=="RAND")
msp.rand <- getSamples(pairs, element="exprs")[rand,]
hpa.rand <- getSamples(pairs, element="exprs2")[rand,]


###################################################
### chunk number 17: 
###################################################
#line 311 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
msp.rand.med <- apply(msp.rand, 2, median)
msp.rand.mad <- apply(msp.rand, 2, mad)
hpa.rand.med <- apply(hpa.rand, 2, median)
hpa.rand.mad <- apply(hpa.rand, 2, mad)
msp.fail <- msp.rand.med + 2.5*msp.rand.mad
hpa.fail <- hpa.rand.med + 2.5*hpa.rand.mad
hpa.meth <- apply(hpa.rand, 2, quantile, 0.99)


###################################################
### chunk number 18: 
###################################################
#line 321 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
norand <- which(getFeatures(pairs, "TYPE")=="DATA")
size <- as.numeric(getFeatures(pairs, "SIZE"))[norand]
msp <- getSamples(pairs, "Brain2", element="exprs")[norand]
hpa <- getSamples(pairs, "Brain2", element="exprs2")[norand]
nofail <- which(msp>msp.fail["Brain2"] | hpa>hpa.fail["Brain2"])
msp.norm <- msp
msp.norm[nofail] <- quantileNormalize(msp[nofail],size[nofail])


###################################################
### chunk number 19: 
###################################################
#line 331 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
meth <- which(msp>msp.fail["Brain2"] & hpa<=hpa.meth["Brain2"])
hpa.norm <- hpa
hpa.norm[meth] <- quantileNormalize(hpa[meth],size[meth])
nometh <- which(hpa>hpa.meth["Brain2"])
hpa.norm[nometh] <- quantileNormalize(hpa[nometh],size[nometh])


###################################################
### chunk number 20: 
###################################################
#line 340 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
pairs.norm <- pairs
exprs(pairs.norm)[norand, "Brain2"] <- msp.norm
exprs2(pairs.norm)[norand, "Brain2"] <- hpa.norm
getSamples(pairs, element="exprs")[1:5,]
getSamples(pairs.norm, element="exprs")[1:5,]


###################################################
### chunk number 21: 
###################################################
#line 364 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
data <- getSamples(pairs,element="exprs2")
seqids <- getFeatures(pairs,'SEQ_ID')
weight <- getSamples(pairs,element="exprs")
combineData(data, seqids, weight, trim=0.2)[1:5,]


###################################################
### chunk number 22: 
###################################################
#line 372 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
combineData(pairs, feature.group='SEQ_ID', trim=0.2)[1:5,]


###################################################
### chunk number 23: fig6
###################################################
#line 387 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpQzt8gR/R.INSTALL66cc50bd/HELP/inst/doc/HELP.Rnw"
plotPairs(pairs,element="exprs2")


