###################################################
### chunk number 1: 
###################################################
#line 6 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
options(width = 80)


###################################################
### chunk number 2: debug
###################################################
#line 39 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
## -- For Debugging / Timing 
## require(RSQLite)
## source("../../R/Genominator.R")
## source("../../R/importAndManage.R")
## source("../../R/plotRegion.R")
## source("../../R/coverage.R")
## source("../../R/goodnessOfFit.R")


###################################################
### chunk number 3: createExpData
###################################################
#line 201 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
library(Genominator)
options(verbose = TRUE) # to be used by Genominator functions.
set.seed(123)
N <- 100000L # the number of observations. 
K <- 100L    # the number of annotation regions, not less than 10
df <- data.frame(chr = sample(1:16, size = N, replace = TRUE),
                 location = sample(1:1000, size = N, replace = TRUE),
                 strand = sample(c(1L,-1L), size = N, replace = TRUE))

head(df)
eDataRaw <- importToExpData(df, "my.db", tablename = "ex_tbl", overwrite = TRUE)
eDataRaw
head(eDataRaw)


###################################################
### chunk number 4: aggregate
###################################################
#line 240 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
eData <- aggregateExpData(eDataRaw, tablename = "counts_tbl",
                          deleteOriginal = FALSE, overwrite = TRUE)
eData
head(eData)


###################################################
### chunk number 5: readOnly
###################################################
#line 283 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
eData <- ExpData(dbFilename = "my.db", tablename = "counts_tbl") 
eData 
head(eData)


###################################################
### chunk number 6: exampleOfSubsetting
###################################################
#line 295 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
head(eData$chr)
eData[1:3, 1:2]


###################################################
### chunk number 7: annoCreate
###################################################
#line 305 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
annoData <- data.frame(chr = sample(1:16, size = K, replace = TRUE),
                       strand = sample(c(1L, -1L), size = K, replace = TRUE),
                       start = (st <- sample(1:1000, size = K, replace = TRUE)),
                       end = st + rpois(K, 75),
                       feature = c("gene", "intergenic")[sample(1:2, size = K, replace = TRUE)])
rownames(annoData) <- paste("elt", 1:K, sep = ".")
head(annoData)


###################################################
### chunk number 8: eData2
###################################################
#line 328 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
df2 <- data.frame(chr = sample(1:16, size = N, replace = TRUE),
                  location = sample(1:1000, size = N, replace = TRUE),
                  strand = sample(c(1L,-1L), size = N, replace = TRUE))
eData2 <- aggregateExpData(importToExpData(df2, dbFilename = "my.db", tablename = "ex2", 
                                           overwrite = TRUE))


###################################################
### chunk number 9: eData1
###################################################
#line 336 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
eData1 <- aggregateExpData(importToExpData(df, dbFilename = "my.db", tablename = "ex1", 
                                           overwrite = TRUE))


###################################################
### chunk number 10: joinExample
###################################################
#line 373 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
## eData1 <- aggregateExpData(importToExpData(df2, dbFilename = "my.db", tablename = "ex1", 
##                                            overwrite = TRUE))
## eData2 <- aggregateExpData(importToExpData(df, dbFilename = "my.db", tablename = "ex2", 
##                                            overwrite = TRUE))
eDataJoin <- joinExpData(list(eData1, eData2), fields = 
                  list(ex1 = c(counts = "counts_1"), ex2 = c(counts = "counts_2")), 
                  tablename = "allcounts")
head(eDataJoin)


###################################################
### chunk number 11: summarizeJoin
###################################################
#line 393 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
summarizeExpData(eDataJoin, fxs = c("total", "avg", "count"))


###################################################
### chunk number 12: collapseExample1
###################################################
#line 410 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
head(collapseExpData(eDataJoin, tablename = "collapsed", collapse = "sum", overwrite = TRUE))


###################################################
### chunk number 13: collapseExample2
###################################################
#line 417 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
head(collapseExpData(eDataJoin, tablename = "collapsed", collapse = "weighted.avg", overwrite = TRUE))
head(collapseExpData(eDataJoin, tablename = "collapsed", collapse = "avg", overwrite = TRUE))


###################################################
### chunk number 14: interfaceSetup
###################################################
#line 435 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
eData <- ExpData("my.db", tablename = "counts_tbl", mode = "r") 
eDataJoin <- ExpData("my.db", tablename = "allcounts", mode = "r")


###################################################
### chunk number 15: sumEx1
###################################################
#line 448 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
ss <- summarizeExpData(eData, what = "counts")
ss


###################################################
### chunk number 16: sumEx2
###################################################
#line 464 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
summarizeExpData(eData, what = "counts", fxs = c("MIN", "MAX"))


###################################################
### chunk number 17: getRegionEx1
###################################################
#line 477 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
reg <- getRegion(eData, chr = 2L, strand = -1L, start = 100L, end = 105L)
class(reg)
reg


###################################################
### chunk number 18: summarizeByAnnotationEx1
###################################################
#line 511 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
head(summarizeByAnnotation(eData, annoData, what = "counts", fxs = c("COUNT", "TOTAL"),
                           bindAnno = TRUE))


###################################################
### chunk number 19: summarizeByAnnotationEx2
###################################################
#line 534 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
head(summarizeByAnnotation(eDataJoin, annoData, , fxs = c("SUM"), 
                           bindAnno = TRUE, preserveColnames = TRUE, ignoreStrand = TRUE))


###################################################
### chunk number 20: summarizeByAnnotationExampleSplit1
###################################################
#line 545 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
res <- summarizeByAnnotation(eData, annoData, what = "counts", fxs = c("TOTAL", "COUNT"), 
                             splitBy = "feature")
class(res)
lapply(res, head)


###################################################
### chunk number 21: summarizeByAnnotationExampleSplit2
###################################################
#line 554 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
res <- summarizeByAnnotation(eData, annoData, what = "counts", fxs = c("TOTAL", "COUNT"), 
                             splitBy = "feature", bindAnno = TRUE)
lapply(res, head)


###################################################
### chunk number 22: splitByAnnotationExample1
###################################################
#line 586 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
dim(annoData[annoData$feature %in% "gene", ])
a <- splitByAnnotation(eData, annoData[annoData$feature %in% "gene", ])
class(a)
length(a)
names(a)[1:10]
head(a[[1]])


###################################################
### chunk number 23: addQuantile
###################################################
#line 606 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
sapply(a, function(x) { quantile(x[,"counts"], .9) })[1:10]


###################################################
### chunk number 24: applyMapped
###################################################
#line 615 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
applyMapped(a, annoData, FUN = function(region, anno) { 
    counts <- sum(region[,"counts"])
    length <- anno$end - anno$start + 1
    counts/length
})[1:10]


###################################################
### chunk number 25: fastSplit
###################################################
#line 635 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
sapply(splitByAnnotation(eData, annoData, what = "counts"), median)[1:10]


###################################################
### chunk number 26: splitByAnnoExtendedExample
###################################################
#line 653 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
## This returns a list-of-lists 
x1 <- splitByAnnotation(eData, annoData, expand = TRUE, ignoreStrand = TRUE)
names(x1[[1]])

## this returns a list-of-lists, however they are of length 1
x2 <- splitByAnnotation(eData, annoData, expand = TRUE)
names(x2[[1]])

## this returns a list where we have combined the two sublists
x3 <- splitByAnnotation(eData, annoData, expand = TRUE, addOverStrand = TRUE)
head(x3[[1]])


###################################################
### chunk number 27: mergeWithAnnotation
###################################################
#line 673 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
mergeWithAnnotation(eData, annoData)[1:3,]


###################################################
### chunk number 28: mergeFig
###################################################
#line 681 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
par(mfrow=c(1,2))
x <- lapply(mergeWithAnnotation(eData, annoData, splitBy = "feature", what = "counts"), 
            function(x) { 
                plot(density(x)) 
            })


###################################################
### chunk number 29: coverage
###################################################
#line 737 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
coverage <- computeCoverage(eData, annoData, effort = seq(100, 1000, by = 5), 
                            cutoff = function(e, anno, group) {e > 1}) 
plot(coverage, draw.legend = FALSE)


###################################################
### chunk number 30: gof1
###################################################
#line 750 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
plot(regionGoodnessOfFit(eDataJoin, annoData))


###################################################
### chunk number 31: gof2
###################################################
#line 756 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
plot(regionGoodnessOfFit(as.data.frame(matrix(rpois(1000, 100), ncol = 10)),
                         groups = rep(c("A", "B"), 5), denominator = rep(1, 10)))


###################################################
### chunk number 32: sessionInfo
###################################################
#line 763 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmprTZGb7/R.INSTALL6abe6328/Genominator/inst/doc/Genominator.Rnw"
toLatex(sessionInfo())


