###################################################
### chunk number 1: 
###################################################
#line 65 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
options(width=65)


###################################################
### chunk number 2: simulateData
###################################################
#line 79 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
set.seed(0)
data <- matrix(rnorm(4000, mean=0), nrow=100, ncol=40)
data[1:30,1:20] <- rnorm(600,mean=1)
phenotype <- factor(rep(c(0,1), each=20))
geneSetName <- "Test Gene Set"


###################################################
### chunk number 3: gsri
###################################################
#line 92 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
library(GSRI)
res <-gsri(data, phenotype, geneSetName, plotResults=TRUE, writeResults=FALSE)


###################################################
### chunk number 4: gsriOutput
###################################################
#line 107 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
print(res)


###################################################
### chunk number 5: gsriGrenander
###################################################
#line 123 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
res2 <-gsri(data, phenotype, "Test Gene Set with Grenander", useGrenander=TRUE)
res2$numRegGenes


###################################################
### chunk number 6: statFcn
###################################################
#line 155 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
statFcn <- function(d, p)  {
m <- lm(d ~ p)
pval <- summary(m)$coefficients[2,4]
}


###################################################
### chunk number 7: testFcn
###################################################
#line 167 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
testFcn <- function(data, phenotype)  {
pvals <- apply(data, 1, statFcn, phenotype)
return(pvals)
}


###################################################
### chunk number 8: gsriOwnTest
###################################################
#line 177 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
res3 <-gsri(data, phenotype, geneSetName, test=testFcn, plotResults=FALSE, nBootstraps=20)


###################################################
### chunk number 9: gsriFromFile
###################################################
#line 206 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
dataFileName <- system.file("extdata", "data.gct", package="GSRI")
phenotypeFileName <- system.file("extdata", "phenotype.cls", package="GSRI")
geneSetFileName <- system.file("extdata", "geneSets.gmt", package="GSRI")
res4 <- gsriFromFile(dataFileName, phenotypeFileName, geneSetFileName)
res4$numRegGenes


###################################################
### chunk number 10: sessionInfo
###################################################
#line 223 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpntzdeO/R.INSTALL3806524/GSRI/inst/doc/gsri.Rnw"
toLatex(sessionInfo(), locale=FALSE)


