###################################################
### chunk number 1: set width
###################################################
#line 30 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
options(width=60)
options(continue=" ")


###################################################
### chunk number 2: load the data
###################################################
#line 50 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
library(ALL)
library(hgu95av2.db)
data(ALL)


###################################################
### chunk number 3: load the packages
###################################################
#line 69 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
library(eisa)


###################################################
### chunk number 4: ISA eval=FALSE
###################################################
## #line 76 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
## set.seed(5) # initialize random number generator to get always the same results
## modules <- ISA(ALL)


###################################################
### chunk number 5: fast ISA
###################################################
#line 83 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
threshold.genes <- 2.7 
threshold.conditions <- 1.4 
set.seed(5)
modules <- ISA(ALL, thr.gene=threshold.genes, thr.cond=threshold.conditions)


###################################################
### chunk number 6: ISAModules summary
###################################################
#line 97 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
modules


###################################################
### chunk number 7: biclust bcplaid
###################################################
#line 110 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
library(biclust)
biclusters <- biclust(exprs(ALL), BCPlaid(), fit.model=~m+a+b, verbose=FALSE)


###################################################
### chunk number 8: isa
###################################################
#line 119 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
as(biclusters, "ISAModules")


###################################################
### chunk number 9: random-modules
###################################################
#line 132 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
modules.genes <- matrix(as.integer(runif(nrow(ALL) * length(modules)) > 0.8), 
                        nrow=nrow(ALL))
modules.conditions <- matrix(as.integer(runif(ncol(ALL) *
                                        length(modules))>0.8),
                        nrow=ncol(ALL))


###################################################
### chunk number 10: toisa
###################################################
#line 143 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
new("ISAModules",
    genes=modules.genes, conditions=modules.conditions,
    rundata=data.frame(), seeddata=data.frame())


###################################################
### chunk number 11: expressionview
###################################################
#line 165 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
library(ExpressionView)
optimalorder <- OrderEV(modules)


###################################################
### chunk number 12: gene maps eval=FALSE
###################################################
## #line 176 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
## optimalorder$genes[i+1]
## optimalorder$samples[i+1]


###################################################
### chunk number 13: status ordering
###################################################
#line 185 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
optimalorder$status


###################################################
### chunk number 14: status ordering eval=FALSE
###################################################
## #line 196 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
## optimalorderp <- OrderEV(modules, initialorder=optimalorder, maxtime=120)


###################################################
### chunk number 15: export eval=FALSE
###################################################
## #line 207 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
## ExportEV(modules, ALL, optimalorder, filename="file.evf")


###################################################
### chunk number 16: export eval=FALSE
###################################################
## #line 229 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
## LaunchEV()


###################################################
### chunk number 17: in-silico
###################################################
#line 333 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
library(ExpressionView)
# generate in-silico data with dimensions m x n 
# containing M overlapping modules
# and add some noise
m <- 50
n <- 500
M <- 10
data <- isa.in.silico(num.rows=m, num.cols=n, 
                      num.fact=M, noise=0.1, overlap.row=5)[[1]]
modules <- isa(data)


###################################################
### chunk number 18: data set annotation
###################################################
#line 349 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
rownames(data) <- paste("row", seq_len(nrow(data)))
colnames(data) <- paste("column", seq_len(ncol(data)))


###################################################
### chunk number 19: rowdata annotation
###################################################
#line 356 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
rowdata <- outer(1:nrow(data), 1:5, function(x, y) {
  paste("row description (", x, ", ", y, ")", sep="")
})             
rownames(rowdata) <- rownames(data)
colnames(rowdata) <- paste("row tag", seq_len(ncol(rowdata)))


###################################################
### chunk number 20: coldata annotation
###################################################
#line 364 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
coldata <- outer(1:ncol(data), 1:10, function(x, y) {
  paste("column description (", x, ", ", y, ")", sep="")
})
rownames(coldata) <- colnames(data)
colnames(coldata) <- paste("column tag", seq_len(ncol(coldata)))


###################################################
### chunk number 21: in-silico data annotation
###################################################
#line 374 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
description <- list(
experiment=list(
	title="Title", 
	xaxislabel="x-Axis Label",
	yaxislabel="y-Axis Label",
	name="Author", 
	lab="Address", 
	abstract="Abstract", 
	url="URL", 
	annotation="Annotation", 
	organism="Organism"),
coldata=coldata,
rowdata=rowdata
)


###################################################
### chunk number 22: in-silico data export eval=FALSE
###################################################
## #line 394 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
## ExportEV(modules, data, filename="file.evf", 
##          description=description)


###################################################
### chunk number 23: sessioninfo
###################################################
#line 408 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpgGRIZE/R.INSTALL54b75129/ExpressionView/inst/doc/ExpressionView.tutorial.Rnw"
toLatex(sessionInfo())


