###################################################
### chunk number 1: countsTable
###################################################
#line 63 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
library("DESeq")
countsTable <- read.delim(system.file("extra/TagSeqExample.tab", package="DESeq"), 
                          header=TRUE, stringsAsFactors=TRUE, row.names="gene")
conds <- factor(c("T", "T", "T", "Tb", "N", "N"))


###################################################
### chunk number 2: countsTable
###################################################
#line 70 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head(countsTable)
conds


###################################################
### chunk number 3: demo1
###################################################
#line 76 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds <- newCountDataSet( countsTable, conds )
cds <- estimateSizeFactors( cds )
cds <- estimateVarianceFunctions( cds )
res <- nbinomTest( cds, "T", "N")


###################################################
### chunk number 4: res
###################################################
#line 85 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head(res)


###################################################
### chunk number 5: 
###################################################
#line 108 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
library( DESeq )
exampleFile = system.file( "extra/TagSeqExample.tab", package="DESeq" )
exampleFile


###################################################
### chunk number 6: 
###################################################
#line 115 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
countsTable <- read.delim( exampleFile, header=TRUE, stringsAsFactors=TRUE )
head( countsTable )


###################################################
### chunk number 7: 
###################################################
#line 123 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
rownames( countsTable ) <- countsTable$gene
countsTable <- countsTable[ , -1 ]


###################################################
### chunk number 8: 
###################################################
#line 133 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
conds <- c( "T", "T", "T", "Tb", "N", "N" )


###################################################
### chunk number 9: 
###################################################
#line 144 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds <- newCountDataSet( countsTable, conds )


###################################################
### chunk number 10: 
###################################################
#line 151 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head( counts(cds) )


###################################################
### chunk number 11: 
###################################################
#line 157 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds <- cds[ ,-1 ]


###################################################
### chunk number 12: 
###################################################
#line 169 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
libsizes <- c( T1a=6843583, T1b=7604834, T2=13625570, T3=12291910,
   N1=12872125, N2=10502656 )
sizeFactors(cds) <- libsizes[-1]


###################################################
### chunk number 13: 
###################################################
#line 177 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds <- estimateSizeFactors( cds )
sizeFactors( cds )


###################################################
### chunk number 14: 
###################################################
#line 191 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds <- estimateVarianceFunctions( cds )


###################################################
### chunk number 15: 
###################################################
#line 213 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
countValue <- 123
baseLevel <- countValue / sizeFactors(cds)["T1b"]
rawVarFuncForGB <- rawVarFunc( cds, "T" )
rawVariance <- rawVarFuncForGB( baseLevel )
fullVariance <- countValue + rawVariance * sizeFactors(cds)["T1b"]^2
sqrt( fullVariance )


###################################################
### chunk number 16: figSCV
###################################################
#line 240 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
scvPlot( cds, ylim=c(0,2) )


###################################################
### chunk number 17: 
###################################################
#line 266 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
rawVarFuncTable( cds )


###################################################
### chunk number 18: 
###################################################
#line 288 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
diagForT <- varianceFitDiagnostics( cds, "T" )
head( diagForT )


###################################################
### chunk number 19: figFit
###################################################
#line 302 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
smoothScatter( log10(diagForT$baseMean), log10(diagForT$baseVar) )
lines( log10(fittedBaseVar) ~ log10(baseMean), 
   diagForT[ order(diagForT$baseMean), ], col="red" )


###################################################
### chunk number 20: figECDF
###################################################
#line 326 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
par( mfrow=c(1,2 ) )
residualsEcdfPlot( cds, "T" )
residualsEcdfPlot( cds, "N" )


###################################################
### chunk number 21: 
###################################################
#line 355 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
res <- nbinomTest( cds, "N", "T" )
head(res)


###################################################
### chunk number 22: figDE
###################################################
#line 378 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
plotDE <- function( res )
   plot( 
      res$baseMean, 
      res$log2FoldChange, 
      log="x", pch=20, cex=.1, 
      col = ifelse( res$padj < .1, "red", "black" ) )

plotDE( res )


###################################################
### chunk number 23: 
###################################################
#line 392 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
resSig <- res[ res$padj < .1, ]


###################################################
### chunk number 24: 
###################################################
#line 396 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head( resSig[ order(resSig$pval), ] )


###################################################
### chunk number 25: 
###################################################
#line 402 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head( resSig[ order( resSig$foldChange, -resSig$baseMean ), ] )


###################################################
### chunk number 26: 
###################################################
#line 406 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head( resSig[ order( -resSig$foldChange, -resSig$baseMean ), ] )


###################################################
### chunk number 27: figResVarDens
###################################################
#line 428 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
plot( density( res$resVarA, na.rm=TRUE, from=0, to=20 ), col="red" )
lines( density( res$resVarB, na.rm=TRUE, from=0, to=20 ), col="blue" )
xg <- seq( 0, 20, length.out=1000 ); lines( xg, dchisq( xg, df=1 ), col="grey" )


###################################################
### chunk number 28: 
###################################################
#line 445 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
table( res$resVarA > 15 | res$resVarB > 15)


###################################################
### chunk number 29: 
###################################################
#line 450 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
( 1 - pchisq( 15, df=1) ) * nrow(counts(cds))


###################################################
### chunk number 30: 
###################################################
#line 518 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
resTbvsN <- nbinomTest( cds, "N", "Tb" )


###################################################
### chunk number 31: figDE_Tb
###################################################
#line 522 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
plot( 
   resTbvsN$baseMean, 
   resTbvsN$log2FoldChange, 
   log="x", pch=20, cex=.1, 
   col = ifelse( resTbvsN$padj < .1, "red", "black" ) )


###################################################
### chunk number 32: 
###################################################
#line 560 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds2 <- cds[ ,c( "T1b", "N1" ) ]


###################################################
### chunk number 33: 
###################################################
#line 567 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds2 <- estimateVarianceFunctions( cds2, method="blind" )


###################################################
### chunk number 34: 
###################################################
#line 572 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
res2 <- nbinomTest( cds2, "N", "T" )


###################################################
### chunk number 35: figDE2
###################################################
#line 584 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
plot( 
   res2$baseMean,
   res2$log2FoldChange, 
   log="x", pch=20, cex=.1, 
   col = ifelse( res2$padj < .1, "red", "black" ) )


###################################################
### chunk number 36: 
###################################################
#line 592 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
addmargins( table( res_sig = res$padj < .1, res2_sig = res2$padj < .1 ) )


###################################################
### chunk number 37: 
###################################################
#line 605 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
colsN <- conditions(cds) == "N"
colsT <- conditions(cds) == "T"
baseMeansNT <- getBaseMeansAndVariances( 
   counts(cds)[ , colsN|colsT ], 
   sizeFactors(cds)[ colsN|colsT ] )$baseMean
pvals2b <- nbinomTestForMatrices(
   counts(cds)[ ,colsN ],
   counts(cds)[ ,colsT ],
   sizeFactors(cds)[ colsN ],
   sizeFactors(cds)[ colsT ],
   rawVarFunc( cds2, "_blind", TRUE )( baseMeansNT ),
   rawVarFunc( cds2, "_blind", TRUE )( baseMeansNT ) )


###################################################
### chunk number 38: 
###################################################
#line 621 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
padj2b <- p.adjust( pvals2b, method="BH" )
notNAinRes2 <- !is.na( res2$padj )
addmargins( table( 
   res_sig = res$padj[notNAinRes2] < .1, 
   res2b_sig = padj2b[notNAinRes2] < .1 ) )


###################################################
### chunk number 39: 
###################################################
#line 643 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
cds3 <- newCountDataSet( countsTable, conds )
cds3 <- estimateSizeFactors( cds3 )
cds3 <- estimateVarianceFunctions( cds3 )


###################################################
### chunk number 40: 
###################################################
#line 650 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
vsd <- getVarianceStabilizedData( cds3 )


###################################################
### chunk number 41: 
###################################################
#line 654 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
head( vsd )


###################################################
### chunk number 42: 
###################################################
#line 667 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
dists <- dist( t( vsd ) )


###################################################
### chunk number 43: figHeatmap
###################################################
#line 672 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
heatmap( as.matrix( dists ), symm=TRUE )


###################################################
### chunk number 44: 
###################################################
#line 728 "E:/biocbld/bbs-2.7-bioc/tmpdir/RtmpWu1gng/R.INSTALL4c450c/DESeq/inst/doc/DESeq.Rnw"
sessionInfo()


