/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.experiment.CSVResultListener;
import weka.experiment.ResultProducer;

public class InstancesResultListener
extends CSVResultListener {
    protected transient FastVector m_Instances;
    protected transient int[] m_AttributeTypes;
    protected transient Hashtable[] m_NominalIndexes;
    protected transient FastVector[] m_NominalStrings;

    public InstancesResultListener() {
        File file;
        try {
            file = File.createTempFile("weka_experiment", ".arff");
            file.deleteOnExit();
        }
        catch (Exception exception) {
            System.err.println("Cannot create temp file, writing to standard out.");
            file = new File("-");
        }
        this.setOutputFile(file);
        this.setOutputFileName("");
    }

    public String globalInfo() {
        return "Takes results from a result producer and assembles them into a set of instances.";
    }

    public void preProcess(ResultProducer resultProducer) throws Exception {
        this.m_RP = resultProducer;
        this.m_Out = this.m_OutputFile == null || this.m_OutputFile.getName().equals("-") ? new PrintWriter(System.out, true) : new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.m_OutputFile)), true);
        Object[] objectArray = this.m_RP.getKeyTypes();
        Object[] objectArray2 = this.m_RP.getResultTypes();
        this.m_AttributeTypes = new int[objectArray.length + objectArray2.length];
        this.m_NominalIndexes = new Hashtable[this.m_AttributeTypes.length];
        this.m_NominalStrings = new FastVector[this.m_AttributeTypes.length];
        this.m_Instances = new FastVector();
        for (int i = 0; i < this.m_AttributeTypes.length; ++i) {
            Object object = null;
            object = i < objectArray.length ? objectArray[i] : objectArray2[i - objectArray.length];
            if (object instanceof String) {
                this.m_AttributeTypes[i] = 1;
                this.m_NominalIndexes[i] = new Hashtable();
                this.m_NominalStrings[i] = new FastVector();
                continue;
            }
            if (object instanceof Double) {
                this.m_AttributeTypes[i] = 0;
                continue;
            }
            throw new Exception("Unknown attribute type in column " + (i + 1));
        }
    }

    public void postProcess(ResultProducer resultProducer) throws Exception {
        int n;
        if (this.m_RP != resultProducer) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        String[] stringArray = this.m_RP.getKeyNames();
        String[] stringArray2 = this.m_RP.getResultNames();
        FastVector fastVector = new FastVector();
        block5: for (int i = 0; i < this.m_AttributeTypes.length; ++i) {
            String string = "Unknown";
            string = i < stringArray.length ? "Key_" + stringArray[i] : stringArray2[i - stringArray.length];
            switch (this.m_AttributeTypes[i]) {
                case 1: {
                    if (this.m_NominalStrings[i].size() > 0) {
                        fastVector.addElement(new Attribute(string, this.m_NominalStrings[i]));
                        continue block5;
                    }
                    fastVector.addElement(new Attribute(string, (FastVector)null));
                    continue block5;
                }
                case 0: {
                    fastVector.addElement(new Attribute(string));
                    continue block5;
                }
                case 2: {
                    fastVector.addElement(new Attribute(string, (FastVector)null));
                    continue block5;
                }
                default: {
                    throw new Exception("Unknown attribute type");
                }
            }
        }
        Instances instances = new Instances("InstanceResultListener", fastVector, this.m_Instances.size());
        for (n = 0; n < this.m_Instances.size(); ++n) {
            instances.add((Instance)this.m_Instances.elementAt(n));
        }
        this.m_Out.println(new Instances(instances, 0));
        for (n = 0; n < instances.numInstances(); ++n) {
            this.m_Out.println(instances.instance(n));
        }
        if (this.m_OutputFile != null && !this.m_OutputFile.getName().equals("-")) {
            this.m_Out.close();
        }
    }

    public void acceptResult(ResultProducer resultProducer, Object[] objectArray, Object[] objectArray2) throws Exception {
        if (this.m_RP != resultProducer) {
            throw new Error("Unrecognized ResultProducer sending results!!");
        }
        Instance instance = new Instance(this.m_AttributeTypes.length);
        block4: for (int i = 0; i < this.m_AttributeTypes.length; ++i) {
            Object object = null;
            object = i < objectArray.length ? objectArray[i] : objectArray2[i - objectArray.length];
            if (object == null) {
                instance.setValue(i, Instance.missingValue());
                continue;
            }
            switch (this.m_AttributeTypes[i]) {
                case 1: {
                    String string = (String)object;
                    Double d = (Double)this.m_NominalIndexes[i].get(string);
                    if (d == null) {
                        d = new Double(this.m_NominalStrings[i].size());
                        this.m_NominalIndexes[i].put(string, d);
                        this.m_NominalStrings[i].addElement(string);
                    }
                    instance.setValue(i, (double)d);
                    continue block4;
                }
                case 0: {
                    double d = (Double)object;
                    instance.setValue(i, d);
                    continue block4;
                }
                default: {
                    instance.setValue(i, Instance.missingValue());
                }
            }
        }
        this.m_Instances.addElement(instance);
    }
}

