###################################################
### chunk number 1: FileDemo
###################################################
#line 42 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
library(AnnotationDbi)
read.table(system.file("extdata", "hcg110_ID",
                       package="AnnotationDbi"),
           sep = "\t", header = FALSE, as.is = TRUE)[1:5,]


###################################################
### chunk number 2: availableDB0s
###################################################
#line 113 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
  available.db0pkgs()  


###################################################
### chunk number 3: GetIntermedDB eval=FALSE
###################################################
## #line 126 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
##   source("http://bioconductor.org/biocLite.R")
##   biocLite("human.db0")


###################################################
### chunk number 4: PopulateSetup
###################################################
#line 160 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
hcg110_IDs = system.file("extdata",
                           "hcg110_ID",
                           package="AnnotationDbi")

myMeta = c("DBSCHEMA"="HUMANCHIP_DB",
           "ORGANISM"="Homo sapiens",
           "SPECIES"="Human",
           "MANUFACTURER"="Affymetrix",
           "CHIPNAME"="Human Cancer G110 Array ",
           "MANUFACTURERURL"="http://www.affymetrix.com")


###################################################
### chunk number 5: TempDirPopulate
###################################################
#line 182 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
tmpout = tempdir()
##To see what chip packages are available:
available.chipdbschemas()
##Then you can make a DB using that schema.
populateDB("HUMANCHIP_DB", affy = FALSE, prefix = "hcg110Test",
    fileName = hcg110_IDs, metaDataSrc = myMeta,
    baseMapType = "gb", outputDir = tmpout)


###################################################
### chunk number 6: MakeAnnDbPkg
###################################################
#line 197 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
seed <- new("AnnDbPkgSeed",             
            Package = "hcg110Test.db",
            Version = "1.0.0",
            PkgTemplate = "HUMANCHIP.DB",
            AnnObjPrefix = "hcg110Test")

makeAnnDbPkg(seed,
             file.path(tmpout, "hcg110Test.sqlite"),
             dest_dir = tmpout)


###################################################
### chunk number 7: cleanup
###################################################
#line 208 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
file.remove(file.path(tmpout, "hcg110Test.sqlite"))
file.rename(file.path(tmpout, "hcg110Test.db"),file.path(tmpout, "fooTest.db"))


###################################################
### chunk number 8: SQLForge
###################################################
#line 219 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
makeDBPackage("HUMANCHIP_DB",
              affy=FALSE,            
              prefix="hcg110",
              fileName=hcg110_IDs,
              baseMapType="gb",
              outputDir = tmpout,
              version="1.0.0",
              manufacturer = "Affymetrix",
              chipName = "Human Cancer G110 Array",
              manufacturerUrl = "http://www.affymetrix.com")


###################################################
### chunk number 9: cleanup2
###################################################
#line 231 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
file.remove(file.path(tmpout, "hcg110.sqlite"))
file.rename(file.path(tmpout, "hcg110.db"),file.path(tmpout, "foo.db"))


###################################################
### chunk number 10: install eval=FALSE
###################################################
## #line 254 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
## install.packages("packageNameAndPath", repos=NULL, type="source")


###################################################
### chunk number 11: createSimpleMapping
###################################################
#line 294 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
library(hgu95av2.db)
hgu95av2NAMESYMBOL <- createSimpleBimap("gene_info",
                                        "gene_name",
                                        "symbol",
                                        hgu95av2.db:::datacache,
                                        "NAMESYMBOL",
                                        "hgu95av2.db")
##What is the mapping we just made?
hgu95av2NAMESYMBOL
##Display the 1st 4 relationships in this new mapping
as.list(hgu95av2NAMESYMBOL)[1:4]


###################################################
### chunk number 12: SessionInfo
###################################################
#line 322 "E:/biocbld/bbs-2.7-bioc/tmpdir/Rtmp04SrsB/R.INSTALLc9344b7/AnnotationDbi/inst/doc/SQLForge.Rnw"
sessionInfo()


