###################################################
### chunk number 1: loading rGADEM package
###################################################
library(rGADEM)


###################################################
### chunk number 2: loading BSgenome package
###################################################
library(BSgenome.Hsapiens.UCSC.hg18)


###################################################
### chunk number 3: BED File
###################################################
pwd<-"" #INPUT FILES- BedFiles, FASTA, etc.
path<- system.file("extdata/Test_100.bed",package="rGADEM")
BedFile<-paste(pwd,path,sep="")
BED<-read.table(BedFile,header=FALSE,sep="\t")
BED<-data.frame(chr=as.factor(BED[,1]),start=as.numeric(BED[,2]),end=as.numeric(BED[,3]))


###################################################
### chunk number 4: Create the RD Files
###################################################
rgBED<-IRanges(start=BED[,2],end=BED[,3])
Sequences<-RangedData(rgBED,space=BED[,1])


###################################################
### chunk number 5: Create the RD Files eval=FALSE
###################################################
## 
## pwd<-"" #INPUT FILES- BedFiles, FASTA, etc.
## path<- system.file("extdata/Test_100.bed",package="rGADEM")
## FastaFile<-paste(pwd,path,sep="")
## Sequences <- read.XStringViews(FastaFile,"fasta",subjectClass="DNAString")


###################################################
### chunk number 6: rGADEM analysis
###################################################
gadem<-GADEM(Sequences,verbose=1,genome=Hsapiens)


###################################################
### chunk number 7: prepare PWM eval=FALSE
###################################################
## path<- system.file("extdata/jaspar2009.txt",package="rGADEM")
## seededPwm<-readTransfacFile(path)
## grep("STAT1",names(seededPwm))
## STAT1.PWM=seededPwm[103]


###################################################
### chunk number 8: rGADEM seeded analysis eval=FALSE
###################################################
## gadem<-GADEM(Sequences,verbose=1,genome=Hsapiens,Spwm=STAT1.PWM)


###################################################
### chunk number 9: pwm
###################################################
viewPWM(gadem)


###################################################
### chunk number 10: pwm
###################################################
viewPWM(gadem)[1]


###################################################
### chunk number 11: consensus
###################################################
consensus(gadem)


###################################################
### chunk number 12: consensus
###################################################
consensus(gadem)[1]


###################################################
### chunk number 13: position
###################################################
startPos(gadem)


###################################################
### chunk number 14: position
###################################################
endPos(gadem)


###################################################
### chunk number 15: parameters eval=FALSE
###################################################
## gadem@parameters


