###################################################
### chunk number 1: load_library
###################################################
library(goseq)


###################################################
### chunk number 2: set_width
###################################################
options(width=84)


###################################################
### chunk number 3: read.data eval=FALSE
###################################################
## gene.vector=as.integer(assayed.genes%in%de.genes)
## names(gene.vector)=assayed.genes


###################################################
### chunk number 4: supported_genomes eval=FALSE
###################################################
## supportedGenomes()


###################################################
### chunk number 5: supported_geneids eval=FALSE
###################################################
## supportedGeneIDs()


###################################################
### chunk number 6: edger_1
###################################################
library(edgeR)
table.summary=read.table(system.file("extdata","Li_sum.txt",package='goseq'),sep='\t',header=TRUE,stringsAsFactors=FALSE)
counts=table.summary[,-1]
rownames(counts)=table.summary[,1]
grp=factor(rep(c("Control","Treated"),times=c(4,3)))
summarized=DGEList(counts,lib.size=colSums(counts),group=grp)


###################################################
### chunk number 7: edger_2
###################################################
disp=estimateCommonDisp(summarized)
tested=exactTest(disp)
topTags(tested)


###################################################
### chunk number 8: edger_3
###################################################
genes=as.integer(p.adjust(tested$table$p.value[tested$table$logFC!=0],method="BH")<.05)
names(genes)=row.names(tested$table[tested$table$logFC!=0,])
table(genes)


###################################################
### chunk number 9: head_genomes
###################################################
head(supportedGenomes())


###################################################
### chunk number 10: head_geneids
###################################################
head(supportedGeneIDs(),n=12)


###################################################
### chunk number 11: pwf
###################################################
pwf=nullp(genes,"hg18","ensGene")


###################################################
### chunk number 12: GO.wall
###################################################
GO.wall=goseq(genes,pwf,"hg18","ensGene")
head(GO.wall)


###################################################
### chunk number 13: GO.samp
###################################################
GO.samp=goseq(genes,pwf,"hg18","ensGene",method="Sampling",repcnt=1000)


###################################################
### chunk number 14: head_samp
###################################################
head(GO.samp)


###################################################
### chunk number 15: plot_wal_v_samp
###################################################
plot(log10(GO.wall[,2]), log10(GO.samp[match(GO.samp[,1],GO.wall[,1]),2]), xlab="log10(Wallenius p-values)", ylab="log10(Sampling p-values)", xlim=c(-3,0))
abline(0,1,col=3,lty=2)


###################################################
### chunk number 16: GO.nobias
###################################################
GO.nobias=goseq(genes,pwf,"hg18","ensGene",method="Hypergeometric")
head(GO.nobias)


###################################################
### chunk number 17: plot_wal_v_hyper
###################################################
plot(log10(GO.wall[,2]), log10(GO.nobias[match(GO.nobias[,1],GO.wall[,1]),2]), xlab="log10(Wallenius p-values)", ylab="log10(Hypergeometric p-values)", xlim=c(-3,0), ylim=c(-3,0))
abline(0,1,col=3,lty=2)


###################################################
### chunk number 18: GO.limited
###################################################
GO.MF=goseq(genes,pwf,"hg18","ensGene",test.cats=c("GO:MF"))
head(GO.MF)


###################################################
### chunk number 19: enriched_GO
###################################################
enriched.GO=GO.wall$category[p.adjust(GO.wall$upval,method="BH")<.05]
head(enriched.GO)


###################################################
### chunk number 20: GO_explained
###################################################
library(GO.db)
for(go in enriched.GO[1:10]){
	print(GOTERM[[go]])
	cat("--------------------------------------\n")
}


###################################################
### chunk number 21: getlength
###################################################
len=getlength(names(genes),"hg18","ensGene")
length(len)
length(genes)
head(len)


###################################################
### chunk number 22: getgo
###################################################
go=getgo(names(genes),"hg18","ensGene")
length(go)
length(genes)
head(go)


###################################################
### chunk number 23: norm_analysis eval=FALSE
###################################################
## pwf=nullp(genes,"hg18","ensGene")
## go=goseq(genes,pwf,"hg18","ensGene")


###################################################
### chunk number 24: verbose_analysis eval=FALSE
###################################################
## gene_lengths=getlength(names(genes),"hg18","ensGene")
## pwf=nullp(genes,bias.data=gene_lengths)
## go_map=getgo(names(genes),"hg18","ensGene")
## go=goseq(genes,pwf,gene2cat=go_map)


###################################################
### chunk number 25: KEGG_mappings eval=FALSE
###################################################
## #Get the mapping from ENSEMBL 2 Entrez
## en2eg=as.list(org.Hs.egENSEMBL2EG)
## #Get the mapping from Entrez 2 KEGG
## eg2kegg=as.list(org.Hs.egPATH)
## #Define a function which gets all unique KEGG IDs associated with a set of Entrez IDs
## grepKEGG=function(id,mapkeys){unique(unlist(mapkeys[id],use.names=FALSE))}
## #Apply this function to every entry in the mapping from ENSEMBL 2 Entrez to combine the two maps
## kegg=lapply(en2eg,grepKEGG,eg2kegg)
## head(kegg)


###################################################
### chunk number 26: KEGG eval=FALSE
###################################################
## pwf=nullp(genes,"hg18","ensGene")
## KEGG=goseq(genes,pwf,gene2cat=kegg)
## head(KEGG)


###################################################
### chunk number 27: KEGG_from_db
###################################################
kegg=as.list(org.Hs.egPATH)
head(kegg)


###################################################
### chunk number 28: countbias
###################################################
countbias=rowSums(counts)[rowSums(counts)!=0]
length(countbias)
length(genes)


###################################################
### chunk number 29: GO.counts
###################################################
pwf.counts=nullp(genes,bias.data=countbias)
GO.counts=goseq(genes,pwf.counts,"hg18","ensGene")
head(GO.counts)


###################################################
### chunk number 30: setup
###################################################
sessionInfo()


