###################################################
### chunk number 1: setup
###################################################
library(genomes)
options(warn=-1, width=75, digits=2, scipen=3,  "prompt" = "R> ", "continue" = " ")
options(SweaveHooks=list(fig=function() par(mar=c(5,4.2,1,1))))


###################################################
### chunk number 2: lproks
###################################################
data(lproks)
lproks
summary(lproks)
plot(lproks, log='y', las=1)
data(leuks)
data(lenvs)
lines(leuks, col="red")
lines(lenvs, col="green3")
legend("topleft", c("Microbes", "Eukaryotes", "Metagenomes"),
         lty=1,  bty='n', col=c("blue", "red", "green3"))


###################################################
### chunk number 3: complete
###################################################
complete<-subset(lproks, status=="Complete")
doublingTime(complete)
x<-table(format(complete$released, "%Y"))
barplot(x, col="blue", ylim=c(0,max(x)*1.04), space=0.5, las=1,
axis.lty=1, xlab="Year", ylab="Genomes per year")
box()


###################################################
### chunk number 4: top
###################################################
table2(species(lproks$name))


###################################################
### chunk number 5: yersinia
###################################################
## Yersinia pestis
yp<-subset(lproks, name %like% 'Yersinia pestis*')
plotby(yp, labels=TRUE, cex=.5, lbty='n')



###################################################
### chunk number 6: <gold
###################################################
data(gold)
obligate<-subset(gold, symbiotic.interaction=="Endosymbiotic intracellular", 
c(goldstamp, name, phenotype))
obligate$pathogen<-"Pathogen"
obligate$pathogen[ obligate$phenotype %like% "Non-*|Symb*|Carb"]<-"Commensal"
obligate$pathogen[ obligate$phenotype ==""]<-"Commensal"
table2(genus(obligate$name), obligate$pathogen)


## split comma separated list of phenotypes
x<-subset(gold, phenotype!="")
x2<-strsplit(x$phenotype, ", ")
gold2<- as.data.frame(
 cbind(goldstamp = rep(x$goldstamp, sapply(x2, length)),
            name = rep(x$name, sapply(x2, length)),
       phenotype = unlist(x2)) )
table2(gold2$phenotype)
subset(gold2, phenotype %like% 'Arsenic metabol*')


