###################################################
### chunk number 1: 
###################################################
library(genoCN)


###################################################
### chunk number 2: 
###################################################
data(snpData)
data(snpInfo)

dim(snpData)
dim(snpInfo)

snpData[1:2,]
snpInfo[1:2,]


###################################################
### chunk number 3: 
###################################################
plotCN(pos=snpInfo$Position, LRR=snpData$LRR, BAF=snpData$BAF, 
main = "simulated data on Chr22")


###################################################
### chunk number 4: 
###################################################
Theta = genoCNV(snpInfo$Name, snpInfo$Chr, snpInfo$Position, snpData$LRR, snpData$BAF, 
  snpInfo$PFB, sampleID="simu1", cnv.only=(snpInfo$PFB>1), outputSeg = TRUE, 
  outputSNP = 1, outputTag = "simu1")


###################################################
### chunk number 5: 
###################################################
  
seg = read.table("simu1_segment.txt", header=TRUE)
seg


###################################################
### chunk number 6: 
###################################################
snp = read.table("simu1_SNP.txt", header=TRUE)
dim(snp)
snp[1:2,]


###################################################
### chunk number 7: 
###################################################
plotCN(pos=snpInfo$Position, LRR=snpData$LRR, BAF=snpData$BAF, 
main = "simulated data on Chr22", fileNames="simu1_segment.txt")


