###################################################
### chunk number 1: setup
###################################################
options(width=60)
options(continue=" ")
options(prompt="R> ")


###################################################
### chunk number 2: loadCharm
###################################################
library(charm)
library(charmData)


###################################################
### chunk number 3: dataDir
###################################################
dataDir <- system.file("data", package="charmData")
dataDir


###################################################
### chunk number 4: phenodata
###################################################
phenodataDir <- system.file("extdata", package="charmData")
pd <- read.delim(file.path(phenodataDir, "phenodata.txt"))
phenodataDir
pd


###################################################
### chunk number 5: validatePd
###################################################
res <- validatePd(pd)


###################################################
### chunk number 6: readData
###################################################
rawData <- readCharm(files=pd$filename, path=dataDir, sampleKey=pd)
rawData


###################################################
### chunk number 7: qc
###################################################
qual <- qcReport(rawData, file="qcReport.pdf")
qual


###################################################
### chunk number 8: getControlIndex
###################################################
library(BSgenome.Hsapiens.UCSC.hg18)
ctrlIdx <- getControlIndex(rawData, subject=Hsapiens)


###################################################
### chunk number 9: methp_density
###################################################
grp <- pData(rawData)$tissue
p <- methp(rawData, controlIndex=ctrlIdx, 
	plotDensity="density.pdf", plotDensityGroups=grp) 
head(p)


###################################################
### chunk number 10: dmrFinder
###################################################
dmr <- dmrFinder(rawData, p=p, groups=grp, 
	compare=c("colon", "liver",
	  		  "colon", "spleen"))


###################################################
### chunk number 11: headDmr
###################################################
names(dmr)
names(dmr$tabs)
head(dmr$tabs[[1]])


###################################################
### chunk number 12: 
###################################################
sessionInfo()


