###################################################
### chunk number 1: 
###################################################
library(SPIA)
data(colorectalcancer)
options(digits=3)
head(top)


###################################################
### chunk number 2: 
###################################################
library(hgu133plus2.db)
x <- hgu133plus2ENTREZID 
top$ENTREZ<-unlist(as.list(x[top$ID]))
top<-top[!is.na(top$ENTREZ),]
top<-top[!duplicated(top$ENTREZ),]
tg1<-top[top$adj.P.Val<0.05,]
DE_Colorectal=tg1$logFC
names(DE_Colorectal)<-as.vector(tg1$ENTREZ)
ALL_Colorectal=top$ENTREZ


###################################################
### chunk number 3: 
###################################################
DE_Colorectal[1:10]
ALL_Colorectal[1:10]


###################################################
### chunk number 4: 
###################################################
# pathway analysis based on combined evidence; # use nB=2000 or more for more accurate results
res=spia(de=DE_Colorectal,all=ALL_Colorectal,organism="hsa",nB=2000,plots=FALSE,beta=NULL)
#make the output fit this screen
res$Name=substr(res$Name,1,10)
#show first 15 pathways, ommit KEGG links
res[1:15,-12]


###################################################
### chunk number 5: 
###################################################
plotP(res,threshold=0.05)


###################################################
### chunk number 6: 
###################################################
data(Vessels)
# pathway analysis based on combined evidence; # use nB=2000 or more for more accurate results
res<-spia(de=DE_Vessels,all=ALL_Vessels,organism="hsa",nB=500,plots=FALSE,beta=NULL,verbose=FALSE)
#make the output fit this screen
res$Name=substr(res$Name,1,10)
#show first 15 pathways, ommit KEGG links
res[1:15,-12]


###################################################
### chunk number 7: 
###################################################
res[,"KEGGLINK"][20]


###################################################
### chunk number 8: 
###################################################
rel<-c("activation","compound","binding/association","expression","inhibition","activation_phosphorylation","phosphorylation",
"indirect","inhibition_phosphorylation","dephosphorylation_inhibition","dissociation","dephosphorylation","activation_dephosphorylation",
"state","activation_indirect","inhibition_ubiquination","ubiquination","expression_indirect","indirect_inhibition","repression",
"binding/association_phosphorylation","dissociation_phosphorylation","indirect_phosphorylation")
beta=c(1,0,0,1,-1,1,0,0,-1,-1,0,0,1,0,1,-1,0,1,-1,-1,0,0,0)
names(beta)<-rel
cbind(beta)


###################################################
### chunk number 9: 
###################################################
load(file=paste(system.file("extdata/hsaSPIA.RData",package="SPIA")))
names(path.info[["05210"]])
path.info[["05210"]][["activation"]][48:60,55:60]


###################################################
### chunk number 10: 
###################################################
library(graph)
library(Rgraphviz)

plotG<-function(B){
 nnms<-NULL;colls<-NULL
 mynodes<-colnames(B)
 L<-list();
 n<-dim(B)[1]
 for (i in 1:n){
 L[i]<-list(edges=rownames(B)[abs(B[,i])>0])
 if(sum(B[,i]!=0)>0){
 nnms<-c(nnms,paste(colnames(B)[i],rownames(B)[B[,i]!=0],sep="~"))
 }
 }
 names(L)<-rownames(B)
 g<-new("graphNEL",nodes=mynodes,edgeL=L,edgemode="directed")
 plot(g)
}



###################################################
### chunk number 11: 
###################################################
plotG(path.info[["04012"]][["activation"]])


