###################################################
### chunk number 1: preliminaries
###################################################
library(GeneSelector)


###################################################
### chunk number 2: preliminaries
###################################################
library(GeneSelector)


###################################################
### chunk number 3: 
###################################################
data(toydata)
y <- as.numeric(toydata[1,])
x <- as.matrix(toydata[-1,])
dim(x)
table(y)


###################################################
### chunk number 4: 
###################################################
par(mfrow=c(2,2))
for(i in 1:4) boxplot(x[i,]~y, main=paste("Gene", i))


###################################################
### chunk number 5: 
###################################################
ordT <- RankingTstat(x, y, type="unpaired")


###################################################
### chunk number 6: 
###################################################

getSlots("GeneRanking")
str(ordT)

show(ordT)
toplist(ordT)



###################################################
### chunk number 7: 
###################################################
loo <- GenerateFoldMatrix(y = y, k=1)
show(loo)


###################################################
### chunk number 8: 
###################################################

loor_ordT <- RepeatRanking(ordT, loo)



###################################################
### chunk number 9: 
###################################################

ex1r_ordT <- RepeatRanking(ordT, loo, scheme = "labelexchange")



###################################################
### chunk number 10: 
###################################################

boot <- GenerateBootMatrix(y = y, maxties=3, minclassize=5, repl=30)
show(boot)
boot_ordT <- RepeatRanking(ordT, boot)



###################################################
### chunk number 11: 
###################################################
noise_ordT <- RepeatRanking(ordT, varlist=list(genewise=TRUE, factor=1/10))


###################################################
### chunk number 12: 
###################################################
toplist(loor_ordT, show=FALSE)


###################################################
### chunk number 13: 
###################################################
par(mfrow=c(2,2))
plot(loor_ordT, col="blue", pch=".", cex=2.5, main = "jackknife")
plot(ex1r_ordT, col="blue", pch=".", cex=2.5, main = "label exchange")
plot(boot_ordT, col="blue", pch=".", cex=2.5, main = "bootstrap")
plot(noise_ordT, frac=1/10, col="blue", pch=".", cex=2.5, main = "noise")


###################################################
### chunk number 14: 
###################################################

stab_ex1r_ordT <- GetStabilityOverlap(ex1r_ordT, scheme = "original",
decay="linear")
show(stab_ex1r_ordT)



###################################################
### chunk number 15: 
###################################################

summary(stab_ex1r_ordT, measure = "intersection", display = "all", position = 10)
summary(stab_ex1r_ordT, measure = "overlapscore", display = "all", position = 10)



###################################################
### chunk number 16: 
###################################################
plot(stab_ex1r_ordT, frac = 1, mode = "mean")


###################################################
### chunk number 17: 
###################################################

stab_loo_ordT <- GetStabilityDistance(ex1r_ordT, scheme = "original", measure
= "spearman", decay="linear")
show(stab_loo_ordT)
summary(stab_loo_ordT, display = "all")



###################################################
### chunk number 18: 
###################################################
BaldiLongT <- RankingBaldiLong(x, y, type="unpaired")
FoxDimmicT <- RankingFoxDimmic(x, y, type="unpaired")
sam <- RankingSam(x, y, type="unpaired")
wilcox <- RankingWilcoxon(x, y, type="unpaired")
wilcoxeb <- RankingWilcEbam(x, y, type="unpaired")


###################################################
### chunk number 19: 
###################################################
Merged <- MergeMethods(list(ordT, BaldiLongT, FoxDimmicT, sam, wilcox, wilcoxeb))
HeatmapRankings(Merged, ind=1:40)



###################################################
### chunk number 20: 
###################################################

AggMean <- AggregateSimple(Merged, measure = "mean")
AggMC <- AggregateMC(Merged, type = "MCT", maxrank = 100)
GeneSel <- GeneSelector(list(ordT, BaldiLongT, FoxDimmicT, sam, wilcox,
wilcoxeb), threshold="user", maxrank=50)
show(GeneSel)
sel <- sum(slot(GeneSel, "selected"))

cbind(mean = toplist(AggMean, top = sel, show = F), MC = toplist(AggMC, top
= sel, show = F), GeneSelector = toplist(GeneSel, top = sel, show = F)[,1])



###################################################
### chunk number 21: 
###################################################

plot(GeneSel, which = 1)
    


