###################################################
### chunk number 1: 
###################################################
library('ALL')
data('ALL')
selSamples <- ALL$mol.biol %in% c('ALL1/AF4', 'E2A/PBX1')
ALLs <- ALL[, selSamples]

library('ChromHeatMap')
chrdata<-makeChrStrandData(exprs(ALLs), lib='hgu95av2')


###################################################
### chunk number 2: 
###################################################
groupcol <- ifelse( ALLs$mol.biol == 'ALL1/AF4', 'red', 'green' )
plotChrMap(chrdata, 19, strands='both', RowSideColors=groupcol)


###################################################
### chunk number 3: 
###################################################
plotmap<-plotChrMap(chrdata, 1, cytoband='q23', interval=50000, srtCyto=0, cexCyto=1.2)


###################################################
### chunk number 4:  eval=FALSE
###################################################
## probes <- grabChrMapProbes( plotmap )
## genes <- unlist(mget(probes, envir=hgu95av2SYMBOL, ifnotfound=NA))


###################################################
### chunk number 5: 
###################################################
sessionInfo()


