/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.treevisualizer;

import java.util.Vector;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;

public class PlaceNode2
implements NodePlace {
    private double m_yRatio;
    private Group[] m_groups;
    private Level[] m_levels;
    private int m_groupNum;
    private int m_levelNum;

    public void place(Node node) {
        int n;
        this.m_groupNum = Node.getGCount(node, 0);
        this.m_groups = new Group[this.m_groupNum];
        for (n = 0; n < this.m_groupNum; ++n) {
            this.m_groups[n] = new Group();
            this.m_groups[n].m_gap = 3.0;
            this.m_groups[n].m_start = -1;
        }
        this.groupBuild(node);
        this.m_levelNum = Node.getHeight(node, 0);
        this.m_yRatio = 1.0 / (double)(this.m_levelNum + 1);
        this.m_levels = new Level[this.m_levelNum];
        for (n = 0; n < this.m_levelNum; ++n) {
            this.m_levels[n] = new Level();
        }
        node.setTop(this.m_yRatio);
        this.yPlacer();
        node.setCenter(0.0);
        this.xPlacer(0);
        this.untangle2();
        this.scaleByMax();
    }

    private void xPlacer(int n) {
        if (this.m_groupNum > 0) {
            this.m_groups[0].m_p.setCenter(0.0);
            for (int i = n; i < this.m_groupNum; ++i) {
                Edge edge;
                int n2 = 0;
                double d = this.m_groups[i].m_gap;
                Node node = this.m_groups[i].m_p;
                int n3 = 0;
                while ((edge = node.getChild(n3)) != null) {
                    if (edge.getTarget().getParent(0) == edge) {
                        edge.getTarget().setCenter((double)n3 * d);
                    } else {
                        ++n2;
                    }
                    ++n3;
                }
                this.m_groups[i].m_size = (double)(n3 - 1 - n2) * d;
                this.xShift(i);
            }
        }
    }

    private void xShift(int n) {
        Edge edge;
        double d;
        Node node = this.m_groups[n].m_p;
        double d2 = this.m_groups[n].m_size / 2.0;
        double d3 = this.m_groups[n].m_p.getCenter();
        this.m_groups[n].m_left = d = d3 - d2;
        this.m_groups[n].m_right = d3 + d2;
        int n2 = 0;
        while ((edge = node.getChild(n2)) != null) {
            if (edge.getTarget().getParent(0) == edge) {
                edge.getTarget().adjustCenter(d);
            }
            ++n2;
        }
    }

    private void scaleByMax() {
        double d = 5000.0;
        double d2 = -5000.0;
        for (int i = 0; i < this.m_groupNum; ++i) {
            if (d > this.m_groups[i].m_left) {
                d = this.m_groups[i].m_left;
            }
            if (!(d2 < this.m_groups[i].m_right)) continue;
            d2 = this.m_groups[i].m_right;
        }
        double d3 = d2 - d + 1.0;
        if (this.m_groupNum > 0) {
            Node node = this.m_groups[0].m_p;
            node.setCenter((node.getCenter() - d) / d3);
            for (int i = 0; i < this.m_groupNum; ++i) {
                Edge edge;
                node = this.m_groups[i].m_p;
                int n = 0;
                while ((edge = node.getChild(n)) != null) {
                    Node node2 = edge.getTarget();
                    if (node2.getParent(0) == edge) {
                        node2.setCenter((node2.getCenter() - d) / d3);
                    }
                    ++n;
                }
            }
        }
    }

    private void scaleByInd() {
        Node node = this.m_groups[0].m_p;
        node.setCenter(0.5);
        for (int i = 0; i < this.m_levelNum; ++i) {
            double d = this.m_groups[this.m_levels[i].m_start].m_left;
            double d2 = this.m_groups[this.m_levels[i].m_end].m_right;
            double d3 = d2 - d + 1.0;
            for (int j = this.m_levels[i].m_start; j <= this.m_levels[i].m_end; ++j) {
                Edge edge;
                node = this.m_groups[j].m_p;
                int n = 0;
                while ((edge = node.getChild(n)) != null) {
                    Node node2 = edge.getTarget();
                    if (node2.getParent(0) == edge) {
                        node2.setCenter((node2.getCenter() - d) / d3);
                    }
                    ++n;
                }
            }
        }
    }

    private void untangle2() {
        Ease ease;
        Node node = null;
        Node node2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((ease = this.overlap(n)) != null) {
            Edge edge;
            ++n2;
            int n5 = ease.m_place;
            int n6 = ease.m_place + 1;
            while (n5 != n6) {
                --ease.m_lev;
                n3 = n5;
                n4 = n6;
                n5 = this.m_groups[n5].m_pg;
                n6 = this.m_groups[n6].m_pg;
            }
            n = ease.m_lev;
            int n7 = 0;
            int n8 = 0;
            Node node3 = this.m_groups[n5].m_p;
            Node node4 = this.m_groups[n3].m_p;
            node = null;
            node2 = null;
            int n9 = 0;
            while (node != node4) {
                ++n7;
                node = node3.getChild(n9).getTarget();
                ++n9;
            }
            node4 = this.m_groups[n4].m_p;
            n9 = n7;
            while (node2 != node4) {
                ++n8;
                node2 = node3.getChild(n9).getTarget();
                ++n9;
            }
            Vector<Double> vector = new Vector<Double>(20, 10);
            int n10 = 0;
            while ((edge = node3.getChild(n10)) != null) {
                if (edge.getTarget().getParent(0) == edge) {
                    Double d = new Double(edge.getTarget().getCenter());
                    vector.addElement(d);
                }
                ++n10;
            }
            --n7;
            double d = ease.m_amount / (double)n8;
            int n11 = 0;
            while ((edge = node3.getChild(n11)) != null) {
                node2 = edge.getTarget();
                if (node2.getParent(0) == edge) {
                    if (n11 > n7 + n8) {
                        node2.adjustCenter(ease.m_amount);
                    } else if (n11 > n7) {
                        node2.adjustCenter(d * (double)(n11 - n7));
                    }
                }
                ++n11;
            }
            node = node3.getChild(0).getTarget();
            this.m_groups[n5].m_size = d = node2.getCenter() - node.getCenter();
            this.m_groups[n5].m_left = node3.getCenter() - d / 2.0;
            this.m_groups[n5].m_right = this.m_groups[n5].m_left + d;
            d = this.m_groups[n5].m_left - node.getCenter();
            int n12 = 0;
            int n13 = 0;
            while ((edge = node3.getChild(n13)) != null) {
                node2 = edge.getTarget();
                if (node2.getParent(0) == edge) {
                    node2.adjustCenter(d);
                    double d2 = node2.getCenter() - (Double)vector.elementAt(n13);
                    if (node2.getChild(0) != null) {
                        this.moveSubtree(this.m_groups[n5].m_start + n12, d2);
                        ++n12;
                    }
                }
                ++n13;
            }
        }
    }

    private void moveSubtree(int n, double d) {
        Edge edge;
        Node node = this.m_groups[n].m_p;
        int n2 = 0;
        while ((edge = node.getChild(n2)) != null) {
            if (edge.getTarget().getParent(0) == edge) {
                edge.getTarget().adjustCenter(d);
            }
            ++n2;
        }
        this.m_groups[n].m_left += d;
        this.m_groups[n].m_right += d;
        if (this.m_groups[n].m_start != -1) {
            for (n2 = this.m_groups[n].m_start; n2 <= this.m_groups[n].m_end; ++n2) {
                this.moveSubtree(n2, d);
            }
        }
    }

    private void untangle() {
        Ease ease;
        Node node = null;
        Node node2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((ease = this.overlap(n)) != null) {
            ++n2;
            int n5 = ease.m_place;
            int n6 = ease.m_place + 1;
            while (n5 != n6) {
                --ease.m_lev;
                n3 = n5;
                n4 = n6;
                n5 = this.m_groups[n5].m_pg;
                n6 = this.m_groups[n6].m_pg;
            }
            n = ease.m_lev;
            int n7 = 0;
            int n8 = 0;
            Node node3 = this.m_groups[n5].m_p;
            Node node4 = this.m_groups[n3].m_p;
            node = null;
            node2 = null;
            int n9 = 0;
            while (node != node4) {
                ++n7;
                node = node3.getChild(n9).getTarget();
                ++n9;
            }
            node4 = this.m_groups[n4].m_p;
            n9 = n7;
            while (node2 != node4) {
                ++n8;
                node2 = node3.getChild(n9).getTarget();
                ++n9;
            }
            this.m_groups[n5].m_gap = Math.ceil(ease.m_amount / (double)n8 + this.m_groups[n5].m_gap);
            this.xPlacer(n5);
        }
    }

    private Ease overlap(int n) {
        Ease ease = new Ease();
        for (int i = n; i < this.m_levelNum; ++i) {
            for (int j = this.m_levels[i].m_start; j < this.m_levels[i].m_end; ++j) {
                ease.m_amount = this.m_groups[j].m_right - this.m_groups[j + 1].m_left + 2.0;
                if (!(ease.m_amount >= 0.0)) continue;
                ease.m_amount += 1.0;
                ease.m_lev = i;
                ease.m_place = j;
                return ease;
            }
        }
        return null;
    }

    private void yPlacer() {
        double d = this.m_yRatio;
        int n = 0;
        if (this.m_groupNum > 0) {
            this.m_groups[0].m_p.setTop(this.m_yRatio);
            this.m_levels[0].m_start = 0;
            for (int i = 0; i < this.m_groupNum; ++i) {
                if (this.m_groups[i].m_p.getTop() != d) {
                    this.m_levels[n].m_end = i - 1;
                    this.m_levels[++n].m_start = i;
                    d = this.m_groups[i].m_p.getTop();
                }
                this.nodeY(this.m_groups[i].m_p);
            }
            this.m_levels[n].m_end = this.m_groupNum - 1;
        }
    }

    private void nodeY(Node node) {
        Edge edge;
        double d = node.getTop() + this.m_yRatio;
        int n = 0;
        while ((edge = node.getChild(n)) != null) {
            if (edge.getTarget().getParent(0) == edge) {
                edge.getTarget().setTop(d);
                if (!edge.getTarget().getVisible()) {
                    // empty if block
                }
            }
            ++n;
        }
    }

    private void groupBuild(Node node) {
        if (this.m_groupNum > 0) {
            this.m_groupNum = 0;
            this.m_groups[0].m_p = node;
            ++this.m_groupNum;
            for (int i = 0; i < this.m_groupNum; ++i) {
                this.groupFind(this.m_groups[i].m_p, i);
            }
        }
    }

    private void groupFind(Node node, int n) {
        Edge edge;
        boolean bl = true;
        int n2 = 0;
        while ((edge = node.getChild(n2)) != null) {
            if (edge.getTarget().getParent(0) == edge && edge.getTarget().getChild(0) != null && edge.getTarget().getCVisible()) {
                if (bl) {
                    this.m_groups[n].m_start = this.m_groupNum;
                    bl = false;
                }
                this.m_groups[n].m_end = this.m_groupNum;
                this.m_groups[this.m_groupNum].m_p = edge.getTarget();
                this.m_groups[this.m_groupNum].m_pg = n;
                this.m_groups[this.m_groupNum].m_id = this.m_groupNum;
                ++this.m_groupNum;
            }
            ++n2;
        }
    }

    private class Ease {
        public int m_place;
        public double m_amount;
        public int m_lev;

        private Ease() {
        }
    }

    private class Group {
        public Node m_p;
        public int m_pg;
        public double m_gap;
        public double m_left;
        public double m_right;
        public double m_size;
        public int m_start;
        public int m_end;
        public int m_id;

        private Group() {
        }
    }

    private class Level {
        public int m_start;
        public int m_end;
        public int m_left;
        public int m_right;

        private Level() {
        }
    }
}

