### Name: Hsapiens
### Title: Homo sapiens full genome (UCSC version hg18)
### Aliases: BSgenome.Hsapiens.UCSC.hg18-package
###   BSgenome.Hsapiens.UCSC.hg18 Hsapiens
### Keywords: package data

### ** Examples

Hsapiens
seqlengths(Hsapiens)
Hsapiens$chr1  # same as Hsapiens[["chr1"]]

if ("AGAPS" %in% masknames(Hsapiens)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Hsapiens)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Hsapiens[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



