### Name: Cfamiliaris
### Title: Canis lupus familiaris full genome (UCSC version canFam2)
### Aliases: BSgenome.Cfamiliaris.UCSC.canFam2-package
###   BSgenome.Cfamiliaris.UCSC.canFam2 Cfamiliaris
### Keywords: package data

### ** Examples

Cfamiliaris
seqlengths(Cfamiliaris)
Cfamiliaris$chr1  # same as Cfamiliaris[["chr1"]]

if ("AGAPS" %in% masknames(Cfamiliaris)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Cfamiliaris)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Cfamiliaris[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



