### Name: Celegans
### Title: Caenorhabditis elegans full genome (UCSC version ce2)
### Aliases: BSgenome.Celegans.UCSC.ce2-package BSgenome.Celegans.UCSC.ce2
###   Celegans
### Keywords: package data

### ** Examples

Celegans
seqlengths(Celegans)
Celegans$chrI  # same as Celegans[["chrI"]]

if ("AGAPS" %in% masknames(Celegans)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Celegans)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Celegans[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



