### Name: xmap.plot
### Title: Utility methods for quick graph generation
### Aliases: xmap.plot xmap.points


### ** Examples

  ## Don't show: 
    path     <- tempdir()
    old.path <- Sys.getenv( "XMAP_BRIDGE_CACHE" )
    Sys.setenv( XMAP_BRIDGE_CACHE=path )
  
## End Don't show
  x <- seq( 1000, 100000, by = 1000 )
  y <- runif( length( x ), -10, 10 )

  # This will create a new project, and graph, and add a plot to it
  xmap.plot( x, y, species="homo_sapiens", "1", main="A quick graph", 
             sub="Sub heading", type="area", xlab="Plot 1", col=0xAAFFBB00 )

  # This will add another plot to the same graph
  xmap.points( x, y, type="area", xlab="Plot 2", col=0xAA0000FF )
  ## Don't show: 
    Sys.setenv( XMAP_BRIDGE_CACHE=old.path )
  
## End Don't show



