### Name: fit2DWithin
### Title: Bivariate location normalization function for cDNA microarray
###   data
### Aliases: fit2DWithin
### Keywords: models

### ** Examples

## use the swirl data as example
data(swirl)

## 2D rlm normalization
rlm2D <- fit2DWithin(fun="rlm2Dfit")
swirl1.rlm <- rlm2D(swirl[,1])
norm.M <- swirl1.rlm$residuals ## matrix of normalized ratios

## 2D loess normalization, default span=0.2
loess2D <- fit2DWithin(fun="loess2Dfit")
swirl1.loess <- loess2D(swirl[,1])
## 2D loess normalization, span=0.4
## Not run: 
##D loess2D.1 <- fit2DWithin(fun="loess2Dfit", span=0.4)
##D swirl1.loess.1 <- loess2D.1(swirl[,1])
## End(Not run)

## 2D aov normalization
aov2D <- fit2DWithin(fun="aov2Dfit")
swirl1.aov <- aov2D(swirl[,1])

## 2D spatial median normalization, default window width=3
spatialMed2D <- fit2DWithin(fun="spatialMedfit")
swirl1.spatialMed <- spatialMed2D(swirl[,1])
## 2D loess normalization, window width=9
## Not run: 
##D spatialMed2D.1 <- fit2DWithin(fun="spatialMedfit", width=9)
##D swirl1.spatialMed.1 <- spatialMed2D.1(swirl[,1])
## End(Not run)



