### Name: stam.evaluate
### Title: StAM Evaluation Procedure
### Aliases: stam.evaluate
### Keywords: classif

### ** Examples

# load and normalize some data
## Not run: 
##D library(golubEsets)
##D data(Golub_Merge)
##D 
##D # (root is chosen to yield results reasonably fast, 
##D #  consider GO:0008150 (biological process) to obtain 
##D #  meaningful results)
##D 
##D # demonstrate the use of several combinations of class weights
##D betas <- cbind(c(0.5, 0.8, 0.9), c(0.5, 0.2, 0.1))
##D golubNorm.eval.explore <- stam.evaluate(Golub_Merge, "ALL.AML", 
##D                                          chip="hu6800", root="GO:0005576", 
##D                                          alpha=seq(0, 1, 0.1), beta=betas, ndelta=10)
##D 
##D # demonstrate the use of testsets
##D golubNorm.eval.predict <- stam.evaluate(Golub_Merge, "ALL.AML", testset=39:72,
##D                                          chip="hu6800", root="GO:0005576", ndelta=10)
## End(Not run)


