### Name: ProbBin.flowcytest
### Title: Test the equivalence of two univariate sample distributions by
###   using Probability Binning and plots the probability-binned histograms
###   of the two samples
### Aliases: ProbBin.flowcytest ProbBin.by.control ProbBin.combined
### Keywords: univar hplot

### ** Examples


if (require(rfcdmin)){

data.there<-is.element(c("st.1829", "unst.1829", "st.DRT", "unst.DRT"),objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}

## This only serves as an example.  Usually the FCS object is
## gated and then subset

## HIV negative individual 1829
  IFN.control<-unst.1829@data[1:2000,4]
  IFN.stimul<-st.1829@data[1:2000,4]

## probability binning based on the combined data of both samples
if (interactive()==TRUE){
par(mfrow=c(2,2))
test1.out<-ProbBin.flowcytest(IFN.control, IFN.stimul, varname="Interferon Gamma",
AnalyType="combined", N=200, title="HIV negative individual 1829")
}
## HIV positive individual DRT
  IFN.control2<-unst.DRT@data[1:2000,4]
  IFN.stimul2<-st.DRT@data[1:2000,4]

## probability binning based on the control data only
if (interactive()==TRUE){
test2.out<-ProbBin.flowcytest(IFN.control2, IFN.stimul2,
varname="Interferon Gamma", AnalyType="by.control",
N=100, title="HIV negative individual 1829")
}
## This is an artifical example, but one would expect the
## distributions of the stimulated and control samples
## to be the same in the HIV negative individual 1829
## and to be different in the HIV positive individual DRT
## The test in this example is a bit contrived but
## the bigger picture is achieved.
}




