###################################################
### chunk number 1: 
###################################################
require(plw)


###################################################
### chunk number 2: 
###################################################
data(AffySpikeU95Subset)


###################################################
### chunk number 3: 
###################################################
AffySpikeU95Subset


###################################################
### chunk number 4: 
###################################################
pData(AffySpikeU95Subset)


###################################################
### chunk number 5: 
###################################################
group<-factor(rep(letters[1:2],each=3))
design<-model.matrix(~group-1)
contrast<-matrix(c(1,-1),1,2)


###################################################
### chunk number 6: 
###################################################
design
contrast


###################################################
### chunk number 7: 
###################################################
plwFit<-plw(AffySpikeU95Subset,design=design,contrast=contrast,epsilon=1e-05)


###################################################
### chunk number 8: 
###################################################
plwFit


###################################################
### chunk number 9: 
###################################################
topRankSummary(plwFit,genes=spikedProbesU95)


###################################################
### chunk number 10: 
###################################################
topRankSummary(plwFit,genesOfRank=11:20)


###################################################
### chunk number 11: 
###################################################
topRankSummary(plwFit,nGenes=20)


###################################################
### chunk number 12: 
###################################################
plotSummaryT(plwFit,genes=spikedProbesU95)


###################################################
### chunk number 13: 
###################################################
plotSummaryLog2FC(plwFit,nGenes=15)


###################################################
### chunk number 14: 
###################################################
varHistPlot(plwFit)


###################################################
### chunk number 15: 
###################################################
scaleParameterPlot(plwFit)


###################################################
### chunk number 16: 
###################################################
source("http://www.math.chalmers.se/~astrandm/plw/GetApoAIdata.R")
RG<-GetApoAIdata()
require(limma)
MA <- normalizeWithinArrays(RG)
rownames(MA$M)<-MA$genes$Name
ii<-apply(is.na(MA$M),1,any)
MA$A<-MA$A[!ii,]
MA$M<-MA$M[!ii,]


###################################################
### chunk number 17: 
###################################################
design <- cbind("Control-Ref"=1,"KO-Control"=MA$targets$Cy5=="ApoAI KO")
contrast<-matrix(0:1,ncol=2)


###################################################
### chunk number 18: 
###################################################
design
contrast


###################################################
### chunk number 19: 
###################################################
meanX<-apply(MA$A,1,mean)
knots<-quantile(meanX,seq(0.1,0.9,by=0.2))
lmwFit<-lmw(MA$M,design=design,contrast=contrast,meanX=meanX,knots=knots)


###################################################
### chunk number 20: 
###################################################
lmwFit


###################################################
### chunk number 21: 
###################################################
topRankSummary(lmwFit,nGenes=10)


###################################################
### chunk number 22: 
###################################################
varHistPlot(lmwFit)


###################################################
### chunk number 23: 
###################################################
scaleParameterPlot(lmwFit)


