###################################################
### chunk number 1: Loading required libraries
###################################################
library(lumi)
library(lumiHumanAll.db)


###################################################
### chunk number 2: 
###################################################
## provide an arbitrary nucleotide sequence as an example 
seq <- 'ACGTAAATTTCAGTTTAAAACCCCCCG'
## create a nuID for it
id <- seq2id(seq)
print(id)


###################################################
### chunk number 3: 
###################################################
id2seq(id)


###################################################
### chunk number 4: 
###################################################
is.nuID(id)


###################################################
### chunk number 5: 
###################################################
is.nuID('adfqeqe')


###################################################
### chunk number 6: 
###################################################
  if (require(lumiHumanIDMapping))
 	 lumiHumanIDMapping()


###################################################
### chunk number 7: 
###################################################
  ## Load Illumina example data in lumi package
  data(example.lumi)
  ## Match the chip information of this example data
  if (require(lumiHumanIDMapping))
	getChipInfo(example.lumi, species='Human')


###################################################
### chunk number 8: 
###################################################
  if (require(lumiHumanIDMapping))
	lumiHumanIDMapping_nuID()


###################################################
### chunk number 9: 
###################################################
     nuIDs <- featureNames(example.lumi)
      ## return all mapping information
    if (require(lumiHumanIDMapping))
          nuID2RefSeqID(nuIDs[1:10], lib.mapping='lumiHumanIDMapping', filterTh = c(Strength1 = 95, Uniqueness = 95))


###################################################
### chunk number 10: 
###################################################
   if (require(lumiHumanIDMapping))
        nuID2EntrezID(nuIDs[1:10], lib.mapping='lumiHumanIDMapping', filterTh = c(Strength1 = 95, Uniqueness = 95))


###################################################
### chunk number 11: 
###################################################
   if (require(lumiHumanIDMapping)) {
        mappingInfo <- nuID2RefSeqID(nuIDs[1:10], lib.mapping='lumiHumanIDMapping', returnAllInfo =TRUE)
        head(mappingInfo)
   }


###################################################
### chunk number 12: 
###################################################
     data(example.lumi)
     nuIDs <- featureNames(example.lumi)
     getSYMBOL(nuIDs[1:3], 'lumiHumanAll.db')


###################################################
### chunk number 13: 
###################################################
     getEG(nuIDs[1:3], 'lumiHumanAll.db')


###################################################
### chunk number 14: 
###################################################
     goInfo <- getGO(nuIDs[1], 'lumiHumanAll.db')
     goInfo[[1]][[1]]


###################################################
### chunk number 15: 
###################################################
     lookUp(nuIDs[1:3], "lumiHumanAll.db", what="SYMBOL")


###################################################
### chunk number 16: 
###################################################
     ls('package:lumiHumanAll.db')


