###################################################
### chunk number 1: 
###################################################
options(width=60)


###################################################
### chunk number 2: data
###################################################
library(XDE)
data(expressionSetList)
xlist <- expressionSetList
class(xlist)


###################################################
### chunk number 3: validObject
###################################################
validObject(xlist)


###################################################
### chunk number 4: covariate
###################################################
all(sapply(xlist, function(x, label){ label %in% varLabels(x)}, label="adenoVsquamous"))


###################################################
### chunk number 5: initializeList
###################################################
params <- new("XdeParameter", esetList=xlist, phenotypeLabel="adenoVsquamous")
params


###################################################
### chunk number 6: initializeList2 eval=FALSE
###################################################
## params <- new("XdeParameter", esetList=xlist, 
## 	      phenotypeLabel="adenoVsquamous", one.delta=FALSE)


###################################################
### chunk number 7: burnin eval=FALSE
###################################################
## iterations(params) <- 3
## burnin(params) <- TRUE
## fit <- xde(params, xlist)


###################################################
### chunk number 8: moreIterations eval=FALSE
###################################################
## iterations(params) <- 2
## fit2 <- xde(params, xlist, fit)


###################################################
### chunk number 9: firstMcmc eval=FALSE
###################################################
## firstMcmc(params) <- lastMcmc(fit)
## seed(params) <- seed(fit)
## fit2 <- xde(params, xlist)


###################################################
### chunk number 10: runMoreIterations eval=FALSE
###################################################
## burnin(params) <- FALSE
## iterations(params) <- 2000
## output(params)[c("potential", "acceptance", "nu", "DDelta",
##                  "delta", "probDelta", "sigma2", "phi")] <- 0
## thin(params) <- 2
## xmcmc <- xde(params, xlist)
## ##posteriorAvg(xmcmc) <- calculatePosteriorAvg(xmcmc, NCONC=3)


###################################################
### chunk number 11: loadObject
###################################################
data(xmcmc, package="XDE")


###################################################
### chunk number 12: savedParams
###################################################
output(xmcmc)[2:22][output(xmcmc)[2:22] == 1]


###################################################
### chunk number 13: 
###################################################
pathToLogFiles <- system.file("logFiles", package="XDE")
xmcmc@directory <- pathToLogFiles
c2 <- xmcmc$c2


###################################################
### chunk number 14: c2
###################################################
par(las=1)
plot.ts(c2, ylab="c2", xlab="iterations")


###################################################
### chunk number 15: bayesianEffectSize eval=FALSE
###################################################
## bayesianEffectSize(xmcmc) <- calculateBayesianEffectSize(xmcmc)


###################################################
### chunk number 16: bes
###################################################
bes <- bayesianEffectSize(xmcmc)


###################################################
### chunk number 17: postAvg
###################################################
postAvg <- posteriorAvg(xmcmc)


###################################################
### chunk number 18: postAvgFig_conc
###################################################
par(las=1)
hist(postAvg[, "concordant"], breaks=50, xlim=c(0, 1), main="",
     xlab="posterior probability of concordant differential expression")


###################################################
### chunk number 19: postAvgFig_disc
###################################################
par(las=1)
hist(postAvg[, "discordant"], breaks=50, xlim=c(0, 1), main="",
     xlab="posterior probability of discordant differential expression")


###################################################
### chunk number 20: setPar
###################################################
op.conc <- symbolsInteresting(rankingStatistic=postAvg[, "concordant"])
op.disc <- symbolsInteresting(rankingStatistic=postAvg[, "discordant"])


###################################################
### chunk number 21: conc
###################################################
par(las=1)
graphics:::pairs(bes[op.conc$order, ], pch=op.conc$pch, col=op.conc$col, 
                 bg=op.conc$bg, upper.panel=NULL, cex=op.conc$cex)


###################################################
### chunk number 22: disc
###################################################
graphics:::pairs(bes[op.disc$order, ], pch=op.disc$pch, col=op.disc$col, bg=op.disc$bg, 
		 upper.panel=NULL, cex=op.disc$cex)


###################################################
### chunk number 23: ssAlternatives eval=FALSE
###################################################
## t <- ssStatistic(statistic="t", phenotypeLabel="adenoVsquamous", esetList=xlist)
## if(require(siggenes)){
##   sam <- ssStatistic(statistic="sam", phenotypeLabel="adenoVsquamous", esetList=xlist)
## }
## if(require(GeneMeta)){
##   z <- ssStatistic(statistic="z", phenotypeLabel="adenoVsquamous", esetList=xlist)
## }


###################################################
### chunk number 24: tstatConc eval=FALSE
###################################################
## graphics:::pairs(t[op.conc$order, ], pch=op.conc$pch, col=op.conc$col, 
##                  bg=op.conc$bg, upper.panel=NULL, cex=op.conc$cex)  
## 


###################################################
### chunk number 25: zConc eval=FALSE
###################################################
## graphics:::pairs(t[op.conc$order, ], pch=op.conc$pch, col=op.conc$col, 
##                  bg=op.conc$bg, upper.panel=NULL, cex=op.conc$cex)  
## 


###################################################
### chunk number 26: tstatDisc eval=FALSE
###################################################
## graphics:::pairs(t[op.disc$order, ], pch=op.disc$pch, col=op.disc$col, 
##                  bg=op.disc$bg, upper.panel=NULL, cex=op.disc$cex)  


###################################################
### chunk number 27: pca eval=FALSE
###################################################
## tScores <- xsScores(t, N=nSamples(xlist))
## samScores <- xsScores(sam, nSamples(xlist))
## zScores <- xsScores(z[, match(names(xlist), colnames(z))], N=nSamples(xlist))
## ##Concordant differential expression, we use the combined score from the random effects model directly
## zScores[, "concordant"] <- z[, "zSco"]


###################################################
### chunk number 28: sessionInfo
###################################################
toLatex(sessionInfo())


