### Name: sim.plot.pvals.on.region
### Title: P-value histograms and p-values along the genome per region
### Aliases: sim.plot.pvals.on.region
### Keywords: misc

### ** Examples

#load the datasets and the samples to run the integrated analysis
data(expr.data)
data(acgh.data)
data(samples) 
         
#assemble the data
assemble.data(dep.data = acgh.data, indep.data = expr.data, ann.dep = colnames(acgh.data)[1:4], ann.indep = colnames(expr.data)[1:4], dep.id="ID",dep.chr = "CHROMOSOME",dep.pos = "STARTPOS",dep.symb="Symbol", indep.id="ID",indep.chr = "CHROMOSOME", indep.pos = "STARTPOS", indep.symb="Symbol", overwrite = TRUE,run.name = "chr8")

#run the integrated analysis
integrated.analysis(samples = samples, input.regions = c(8), adjust=FALSE, zscores=TRUE, method = "auto", run.name= "chr8")

# use functions to plot the results of the integrated analysis

#plot the p-values along the region
sim.plot.pvals.on.region(input.regions = c(8), adjust.method="BY", run.name = "chr8")



