### Name: sim.plot.pvals.on.genome
### Title: Plot the p-values in whole genome overview
### Aliases: sim.plot.pvals.on.genome
### Keywords: misc

### ** Examples

#load the datasets and the samples to run the integrated analysis
data(expr.data)
data(acgh.data)
data(samples) 
         
#assemble the data
assemble.data(dep.data=acgh.data, indep.data=expr.data, ann.dep=colnames(acgh.data)[1:4], ann.indep=colnames(expr.data)[1:4], dep.id="ID", dep.chr="CHROMOSOME", dep.pos="STARTPOS", dep.symb="Symbol", indep.id="ID", indep.chr="CHROMOSOME", indep.pos="STARTPOS", indep.symb="Symbol", overwrite=TRUE, run.name="chr8")

#run the integrated analysis
integrated.analysis(samples=samples, input.regions=c(8), adjust=FALSE, zscores=TRUE, method="auto", run.name ="chr8")

#plot the p-values along the genome
sim.plot.pvals.on.genome(input.regions=c(8), adjust.method="BY", pdf=FALSE, run.name="chr8")



