### Name: likelihoods-methods
### Title: Method for predicting the likelihoods of a set of samples with
###   respect to a mutagenetic trees mixture model
### Aliases: likelihoods likelihoods-methods
###   likelihoods,RtreemixModel,RtreemixData-method
### Keywords: methods

### ** Examples

## Create an RtreemixData object from a randomly generated RtreemixModel object.
rand.mod <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
data <- sim(model = rand.mod, no.draws = 300)
show(data)

## Compute the likelihoods of the samples in data with respect to the model rand.mod
mod.stat <- likelihoods(model = rand.mod, data = data)
show(mod.stat)



