### Name: RtreemixStats-class
### Title: Class "RtreemixStats"
### Aliases: LogLikelihoods Model,RtreemixStats WLikelihoods
###   getData,RtreemixStats getResp RtreemixStats-class
###   LogLikelihoods,RtreemixStats-method Model,RtreemixStats-method
###   WLikelihoods,RtreemixStats-method getData,RtreemixStats-method
###   getResp,RtreemixStats-method initialize,RtreemixStats-method
###   print,RtreemixStats-method show,RtreemixStats-method
### Keywords: classes

### ** Examples

## Generate a random RtreemixModel object with 3 components and 9 genetic events.
mod <- generate(K = 3, no.events = 9, noise.tree = TRUE, prob = c(0.2, 0.8))
show(mod)

## Draw a data sample from the model mod.
data <- sim(model = mod, no.draws = 400)

## Create an RtreemixStats object.
mod.stat <- likelihoods(model = mod, data = data)
show(mod.stat)

## See the slots from the RtreemixStats object.
Model(mod.stat)
LogLikelihoods(mod.stat)
WLikelihoods(mod.stat)
## See data.
getData(mod.stat)
## Calculate the responsibilities from the weighted likelihoods.
getResp(mod.stat)



