### Name: parsePsimi25Interaction
### Title: Parsing PSI-MI 2.5 XML documents into interactions
### Aliases: parsePsimi25Interaction parsePsimi25Complex
### Keywords: models

### ** Examples

# parse interaction data
xmlDir <- system.file("/extdata/psi25files",package="RpsiXML")

gridxml <- file.path(xmlDir, "biogrid_200804_test.xml")
gridSet <- parsePsimi25Interaction(gridxml, BIOGRID.PSIMI25)

intactxml <- file.path(xmlDir, "intact_2008_test.xml")
intactSet <- parsePsimi25Interaction(intactxml, INTACT.PSIMI25, verbose=TRUE)

# parse complex data
intactComplexxml <- file.path(xmlDir,"intact_complexSample.xml")
intactComplexSet <- parsePsimi25Complex(intactComplexxml, INTACT.PSIMI25)




