###################################################
### chunk number 1: createGraph1
###################################################
library("Rgraphviz")
set.seed(123)
V <- letters[1:10]
M <- 1:4


###################################################
### chunk number 2: createGraph2
###################################################
g1 <- randomGraph(V, M, 0.2)
g1 <- layoutGraph(g1)
renderGraph(g1)


###################################################
### chunk number 3: bgandfontcol
###################################################
graph.par(list(nodes=list(fill="lightgray", textCol="red")))
renderGraph(g1)


###################################################
### chunk number 4: nodepardefs
###################################################
graph.par(list(nodes=list(col="green", lty="dashed", lwd=2, fontsize=6)))
renderGraph(g1)


###################################################
### chunk number 5: edgepardefs
###################################################
graph.par(list(edges=list(col="blue", lty="dotted", lwd=3)))
renderGraph(g1)


###################################################
### chunk number 6: labels
###################################################
labels <- edgeNames(g1)
names(labels) <- labels
g1 <- layoutGraph(g1, edgeAttrs=list(label=labels))
renderGraph(g1)


###################################################
### chunk number 7: tweaklabesl
###################################################
graph.par(list(edges=list(fontsize=24, textCol="blue")))
renderGraph(g1)


###################################################
### chunk number 8: graphpardefs
###################################################
graph.par(list(graph=list(main="A main title...", 
               sub="... and a subtitle", cex.main=1.8, 
               cex.sub=1.4, col.sub="gray")))
renderGraph(g1)


###################################################
### chunk number 9: nodePars
###################################################
nodeRenderInfo(g1) <- list(fill=c(a="yellow", b="yellow"))
renderGraph(g1) 


###################################################
### chunk number 10: edgePars
###################################################
edgeRenderInfo(g1) <- list(lty=c("g~h"="solid", "g~j"="solid"),
                          col=c("g~h"="orange", "g~j"="orange"))
renderGraph(g1)


###################################################
### chunk number 11: programParms
###################################################
baseNodes <- letters[1:4]
fill <- rep("lightblue", length(baseNodes))
names(fill) <- baseNodes
nodeRenderInfo(g1) <- list(fill=fill)
renderGraph(g1)


###################################################
### chunk number 12: reset
###################################################
# reset the defaults
graph.par(graph:::.default.graph.pars())


###################################################
### chunk number 13: 
###################################################
sessionInfo()


