### Name: FilterRules-class
### Title: Collection of Filter Rules
### Aliases: FilterRules-class active,FilterRules-method
###   active<-,FilterRules-method [,FilterRules,ANY,ANY,ANY-method
###   [[<-,FilterRules-method append,FilterRules,FilterRules-method
###   c,FilterRules-method eval,FilterRules,ANY-method FilterRules
### Keywords: classes methods

### ** Examples

  ## constructing a FilterRules instance

  ## an empty set of filters
  filters <- FilterRules()
  
  ## as a simple character vector
  filts <- c("peaks", "promoters")
  filters <- FilterRules(filts)
  active(filters) # all TRUE

  ## with functions and expressions
  filts <- list(peaks = expression(peaks), promoters = expression(promoters),
                find_eboxes = function(rd) rep(FALSE, nrow(rd)))
  filters <- FilterRules(filts, active = FALSE)
  active(filters) # all FALSE

  ## direct, quoted args (character literal parsed)
  filters <- FilterRules(under_peaks = peaks, in_promoters = "promoters")
  filts <- list(under_peaks = expression(peaks),
                in_promoters = expression(promoters))

  ## specify both exprs and additional args
  filters <- FilterRules(filts, diffexp = de)

  filts <- c("peaks", "promoters", "introns")
  filters <- FilterRules(filts)

  ## set the active state directly
  
  active(filters) <- FALSE # all FALSE
  active(filters) <- TRUE # all TRUE
  active(filters) <- c(FALSE, FALSE, TRUE)
  active(filters)["promoters"] <- TRUE # use a filter name
  
  ## toggle the active state by name or index
  
  active(filters) <- c(NA, 2) # NA's are dropped
  active(filters) <- c("peaks", NA) 



