### Name: decodeCallCodes
### Title: Converts integer codes in a callCodes matrix to character string
###   representations of geneSet.
### Aliases: decodeCallCodes
### Keywords: misc

### ** Examples

library(GeneticsBase)
tTabList <- makeTransTableList(c("Bb", "ATG"), c("Generic", "SNP"))
locus <- c("c104t", "c2249t")
ttab <- c("SNP", "Generic")
minfo <- makeMarkerInfo(locus, ttab)
misscodes <- list(Generic = c("NA", ".", "-"), SNP = "N")
r1 <- c(1, 2, 1, 1)
r2 <- c(1, 2, 3, 2)
data <- rbind(r1, r2) # callCodes
dimnames(data) <- list(locus, paste("Sample", seq(along = r1),
        sep = "."))
decodeCallCodes(data, tTabList, minfo)



