### Name: AggregateSimple
### Title: Simple aggregation of repeated rankings
### Aliases: AggregateSimple
### Keywords: univar

### ** Examples

## Load toy gene expression data
data(toydata)
### class labels
yy <- toydata[1,]
### gene expression
xx <- toydata[-1,]
### run RankingTstat
ordT <- RankingTstat(xx, yy, type="unpaired")
### Generate Leave-one-out Foldmatrix
loo <- GenerateFoldMatrix(xx, yy, k=1)
### Get all rankings
loor_ordT <- GetRepeatRanking(ordT, loo)
### compute stability measure
stab_overlap <- GetStabilityOverlap(loor_ordT, decay="linear")
### aggregate rankings
agg_simple_ordT <- AggregateSimple(loor_ordT, stab_overlap, aggregatefun="mean")



