### Name: import/export
### Title: Read and write gene sets from Broad or GMT formats
### Aliases: io getBroadSets asBroadUri toBroadXML toGmt getGmt
### Keywords: manip

### ** Examples

## 'fl' could also be a URI
fl <- system.file("extdata", "Broad.xml", package="GSEABase")
gss <- getBroadSets(fl) # GeneSetCollection of 2 sets
names(gss)
gss[[1]]

## Not run: 
##D ## Download from the Broad
##D getBroadSets(asBroadUri(c('chr16q', 'GNF2_ZAP70')))
## End(Not run)

fl <- tempfile()
toBroadXML(gss[[1]], con=fl)
noquote(readLines(fl))
unlink(fl)

## Not run: 
##D toBroadXML(gss[[1]]) # character vector
## End(Not run)

fl <- tempfile()
toGmt(gss, fl)
getGmt(fl)
unlink(fl)



