### Name: CollectionType-class
### Title: Class "CollectionType"
### Aliases: CollectionType-class collectionType,CollectionType-method
###   show,CollectionType-method CollectionIdType-class
###   [,CollectionIdType,missing,missing-method
###   Logic,CollectionType,CollectionType-method
###   Logic,CollectionIdType,CollectionIdType-method
###   |,CollectionType,CollectionType-method
###   |,CollectionIdType,CollectionIdType-method
###   &,CollectionType,CollectionType-method
###   &,CollectionIdType,CollectionIdType-method
###   show,CollectionIdType-method ids ids,CollectionIdType-method
###   intersect,CollectionType,CollectionType-method
###   intersect,CollectionIdType,CollectionIdType-method
###   setdiff,CollectionType,CollectionType-method
###   setdiff,CollectionIdType,CollectionIdType-method
###   union,CollectionType,CollectionType-method
###   union,CollectionIdType,CollectionIdType-method NullCollection-class
###   ComputedCollection-class ExpressionSetCollection-class
###   BroadCollection-class bcCategory,BroadCollection-method
###   bcSubCategory,BroadCollection-method show,BroadCollection-method
###   bcCategory bcSubCategory GOCollection-class
###   evidenceCode,GOCollection-method ontology,GOCollection-method
###   goIds,GOCollection-method [,GOCollection,missing,missing-method
###   show,GOCollection-method evidenceCode ontology goIds
###   KEGGCollection-class ChrCollection-class ChrlocCollection-class
###   MapCollection-class OMIMCollection-class PMIDCollection-class
###   PfamCollection-class PrositeCollection-class
### Keywords: classes

### ** Examples

names(getClass("CollectionType")@subclasses)

## Create a CollectionType and ask for its type
collectionType(ExpressionSetCollection())

## Not run: 
##D ## Read two GeneSets from a Broad XML file into a list, verify that
##D ## they are both BroadCollection's. Category / subcategory information
##D ## is unique to Broad collections.
##D fl <- system.file("extdata", "Broad.xml", package="GSEABase")
##D sets <- getBroadSets(fl)
##D sapply(sets, collectionType)
## End(Not run)

## ExpressionSets are tagged with ExpressionSetCollection; there is no
## 'category' information.
data(sample.ExpressionSet)
gs <- GeneSet(sample.ExpressionSet[100:109],
              setName="sample.GeneSet", setIdentifier="123")
collectionType(gs)

## GOCollections are created by reference to GO terms and evidenceCodes
GOCollection("GO:0005488")
## requires library(GO); EntrezIdentifers automatically created
## Not run: 
##D GeneSet(GOCollection(c("GO:0005488", "GO:0019825"),
##D                      evidenceCode="IDA"))
## End(Not run)



