### Name: cluster.visualize
### Title: visualize clustering result using multi-dimensional scaling
### Aliases: cluster.visualize
### Keywords: utilities

### ** Examples

# load sample database from web
db <- cmp.parse("http://bioweb.ucr.edu/ChemMineV2/static/example_db.sdf")
# cluster it, with 2 cutoffs
clusters <- cmp.cluster(db, cutoff=c(0.65, 0.5))
# stat on sizes
sizestat <- cluster.sizestat(clusters)
# visualize it, using a cutoff of 3, write to file 'test.eps'
coord <- cluster.visualize(db, clusters, 3, non.interactive="test.eps")
## Not run: 
##D # visualize it in interactive mode, using a cutoff of 3 and the 2nd clustering result
##D coord <- cluster.visualize(db, clusters, cluster.result=2, 3)
##D # 3D visualization, with scatterplot3d
##D coord <- cluster.visualize(db, clusters, 3, dimensions=3)
##D library(scatterplot3d)
##D scatterplot3d(coord)
## End(Not run)



