### Name: cghCall
### Title: Class to contain and describe called array comparative genomic
###   hybridization data.
### Aliases: class:cghCall cghCall cghCall-class copynumber,cghCall-method
###   copynumber<-,cghCall,matrix-method segmented,cghCall-method
###   segmented<-,cghCall,matrix-method calls,cghCall-method
###   calls<-,cghCall,matrix-method probloss,cghCall-method
###   probloss<-,cghCall,matrix-method probnorm,cghCall-method
###   probnorm<-,cghCall,matrix-method probgain,cghCall-method
###   probgain<-,cghCall,matrix-method probamp,cghCall-method
###   probamp<-,cghCall,matrix-method chromosomes,cghCall-method
###   bpstart,cghCall-method bpend,cghCall-method initialize,cghCall-method
###   plot.cghCall,cghCall,missing-method
###   summaryPlot,cghCall,missing-method
### Keywords: classes

### ** Examples


        # create an instance of cghCall
        new("cghCall")
        
        # load an instance of cghCall
        data(WiltingCalled)
  
  # plot the first sample
  plot.cghCall(WiltingCalled[,1])
  
  # plot the first chromosome of the first sample
  plot.cghCall(WiltingCalled[chromosomes(WiltingCalled)==1,1])

  # get the copynumber values of the third and fourth sample
  log2ratios <- copynumber(WiltingCalled[,3:4])

  # get the names of the samples
  sampleNames(WiltingCalled)

  # get the names of the array elements
  featureNames(WiltingCalled)




