### Name: XString-class
### Title: BString objects
### Aliases: class:XString XString-class class:BString BString-class
###   XString XString,character-method XString,AsIs-method
###   XString,XString-method BString alphabet alphabet,BString-method
###   length,XString-method nchar,XString-method
###   as.character,XString-method toString,XString-method
###   show,XString-method [,XString,ANY,ANY,ANY-method
###   ==,XString,XString-method ==,BString,character-method
###   ==,character,BString-method !=,XString,XString-method
###   !=,BString,character-method !=,character,BString-method
### Keywords: methods classes

### ** Examples

  b <- BString("I am a BString object")
  b
  length(b)

  ## Extracting a linear subsequence 
  subseq(b)
  subseq(b, start=3)
  subseq(b, start=-3)
  subseq(b, end=-3)
  subseq(b, end=-3, width=5)

  ## Subsetting
  b2 <- b[length(b):1]       # better done with reverse(b)

  as.character(b2)

  b2 == b                    # FALSE
  b2 == as.character(b2)     # TRUE

  ## b[1:length(b)] is equal but not identical to b!
  b == b[1:length(b)]        # TRUE
  identical(b, 1:length(b))  # FALSE
  ## This is because subsetting an XString object with [ makes a copy
  ## of part or all its sequence data. Hence, for the resulting object,
  ## the internal slot containing the memory address of the sequence
  ## data differs from the original. This is enough for identical() to
  ## see the 2 objects as different.



