###################################################
### chunk number 1: FileDemo
###################################################
library(AnnotationDbi)
read.table(system.file("extdata", "hcg110_ID",
                       package="AnnotationDbi"),
           sep = "\t", header = FALSE, as.is = TRUE)[1:5,]


###################################################
### chunk number 2: GetIntermedDB eval=FALSE
###################################################
##   source("http://bioconductor.org/biocLite.R")
##   biocLite("human.db0")


###################################################
### chunk number 3: PopulateSetup
###################################################
hcg110_IDs = system.file("extdata",
                           "hcg110_ID",
                           package="AnnotationDbi")

myMeta = c("DBSCHEMA"="HUMANCHIP_DB",
           "ORGANISM"="Homo sapiens",
           "SPECIES"="Human",
           "MANUFACTURER"="Affymetrix",
           "CHIPNAME"="Human Cancer G110 Array ",
           "MANUFACTURERURL"="http://www.affymetrix.com")


###################################################
### chunk number 4: TempDirPopulate
###################################################
tmpout = tempdir()
popHUMANCHIPDB(affy = FALSE, prefix = "hcg110Test",
    fileName = hcg110_IDs, metaDataSrc = myMeta,
    baseMapType = "gb", outputDir = tmpout)


###################################################
### chunk number 5: MakeAnnDbPkg
###################################################
seed <- new("AnnDbPkgSeed",             
            Package = "hcg110Test.db",
            Version = "1.0.0",
            PkgTemplate = "HUMANCHIP.DB",
            AnnObjPrefix = "hcg110Test")

makeAnnDbPkg(seed,
             file.path(tmpout, "hcg110Test.sqlite"),
             dest_dir = tmpout)


###################################################
### chunk number 6: cleanup
###################################################
file.remove(file.path(tmpout, "hcg110Test.sqlite"))
file.rename(file.path(tmpout, "hcg110Test.db"),file.path(tmpout, "fooTest.db"))


###################################################
### chunk number 7: SQLForge
###################################################
makeHUMANCHIP_DB(affy=FALSE,            
    prefix="hcg110",
    fileName=hcg110_IDs,
    baseMapType="gb",
    outputDir = tmpout,
    version="1.0.0",
    manufacturer = "Affymetrix",
    chipName = "Human Cancer G110 Array",
    manufacturerUrl = "http://www.affymetrix.com")


###################################################
### chunk number 8: cleanup2
###################################################
file.remove(file.path(tmpout, "hcg110.sqlite"))
file.rename(file.path(tmpout, "hcg110.db"),file.path(tmpout, "foo.db"))


###################################################
### chunk number 9: SessionInfo
###################################################
sessionInfo()


