\name{print.ABQCList}
\alias{print.ABQCList}

\title{Prints the quality control results for a given data package in a
  nice format}
\description{
  AnnBuilder has a function (\code{getDPStats}) that generates
  some statistical data (a list) for a givan data package for quality control
  purpose. print.ABQCList prints the results in a more readable format. 
}
\usage{
print.ABQCList(x, ...)
}

\arguments{
  \item{x}{\code{x} A list object of class ABQCList that is generated by
    function \code{getDPStats}} 
  \item{\dots}{\code{\dots} Other data to be included (not implemented
    currently)}
}
\details{
  The list object contains the following elements:
  \item{name}{A character string for the name of an rda file}
  \item{built}{A character string for a date}
  \item{probeNum}{An integer for the total number of probes in a given
    base file} 
  \item{numMissMatch}{A vector of character strings for names of rda
    files whose total number of probes do not match that of a given base
    file}  
  \item{probeMissMatch}{A vector of character strings for names of rda
    files whose probes do not match what are in a given base file}
  \item{probeMapped}{A vector of named integers for the total number of
    probes in a probe based rda file that have been mapped to data from
    public data sources. Names of the integers are the names of the rda files}
  \item{otherMapped}{A vector of named integers for the total number of
    probes in a non-probe based rda file that have been mapped to data
    from public data sources. Names of the intergers are the names of
    the rda files} 
}
  
\value{
  No values are returned
}

\author{Jianhua Zhang}
\note{This function is only used for building data packages}

\seealso{\code{getDPStats}}

\examples{
  # Create a ABQCList
x <- c(12250, 7800)
names(x) <- c("file1", "file2")
y <- c(2300, 3456)
names(y) <- c("file3", "file4")
aList <- list(name = "a test", built = date(), probeNum = 12250,
numMissMatch = c("file3", "file4"), probeMissMatch = "file2", probeMapped = x,
otherMapped = y)
class(aList) <- "ABQCList"
aList
}
\keyword{misc}
