### Name: hgu95cPMID
### Title: Map between Manufacturer Identifiers and PubMed Identifiers
### Aliases: hgu95cPMID
### Keywords: datasets

### ** Examples

    # Convert the environment to a list
    xx <- as.list(hgu95cPMID)
    if(length(xx) > 0){
        # The probe identifiers for the first two elements of XX
        xx[1:2]
        # Get the first one
        xx[[1]]
        if(interactive() && !is.null(xx[[1]]) && !is.na(xx[[1]])
           && require(annotate)){
            # Gets article information as XML files
            xmls <- pubmed(xx[[1]], disp = "data")
            # Views article information using a browser
            pubmed(xx[[1]], disp = "browser")
        }
    }



